% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hclust.R
\name{mrkHClust}
\alias{mrkHClust}
\title{Draw a dendrogram of subcellular clusters}
\usage{
mrkHClust(
  object,
  fcol = "markers",
  distargs,
  hclustargs,
  method = mean,
  plot = TRUE,
  ...
)
}
\arguments{
\item{object}{An instance of class \code{MSnSet}.}

\item{fcol}{Feature meta-data label (fData column name) defining
the groups to be differentiated using different
colours. Default is \code{markers}.}

\item{distargs}{A \code{list} of arguments to be passed to the
\code{\link[stats]{dist}} function.}

\item{hclustargs}{A \code{list} of arguments to be passed to the
\code{\link[stats]{hclust}} function.}

\item{method}{A \code{function} to average marker
profiles. Default is \code{mean}.}

\item{plot}{A \code{logical} defining whether the dendrogram
should be plotted. Default is \code{TRUE}.}

\item{...}{Additional parameters passed when plotting the
\code{\link[stats]{dendrogram}}.}
}
\value{
Invisibly returns a dendrogram object, containing the
    hierarchical cluster as computed by \code{hclust}.
}
\description{
This functions calculates an average protein profile for each
marker class (proteins of unknown localisation are ignored) and
then generates a dendrogram representing the relation between
marker classes. The colours used for the dendrogram labels are
taken from the default colours (see \code{\link{getStockcol}}) so
as to match the colours with other spatial proteomics
visualisations such as \code{\link{plot2D}}.
}
\examples{
library("pRolocdata")
data(dunkley2006)
mrkHClust(dunkley2006)
}
\author{
Laurent Gatto
}
