% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MSnSet.R
\name{getMarkers}
\alias{getMarkers}
\title{Get the organelle markers in an \code{MSnSet}}
\usage{
getMarkers(object, fcol = "markers", names = TRUE, verbose = TRUE)
}
\arguments{
\item{object}{An instance of class \code{"\linkS4class{MSnSet}"}.}

\item{fcol}{The name of the markers column in the \code{featureData}
slot. Default is \code{"markers"}.}

\item{names}{A \code{logical} indicating if the markers vector should
be named. Ignored if markers are encoded as a matrix.}

\item{verbose}{If \code{TRUE}, a marker table is printed and the markers
are returned invisibly. If \code{FALSE}, the markers are returned.}
}
\value{
A \code{character} (\code{matrix}) of length (ncol)
\code{ncol(object)}, depending on the vector or matrix encoding of
the markers.
}
\description{
Convenience accessor to the organelle markers in an \code{MSnSet}.
This function returns the organelle markers of an \code{MSnSet}
instance. As a side effect, it print out a marker table.
}
\examples{
library("pRolocdata")
data(dunkley2006)
## marker vectors
myVmarkers <- getMarkers(dunkley2006)
head(myVmarkers)
## marker matrix
dunkley2006 <- mrkVecToMat(dunkley2006, mfcol = "Markers")
myMmarkers <- getMarkers(dunkley2006, fcol = "Markers")
head(myMmarkers)
}
\seealso{
See \code{\link{getMarkerClasses}} to get the classes
only. See \code{\link{markers}} for details about spatial markers
storage and encoding.
}
\author{
Laurent Gatto
}
