% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autism_details.R
\name{jowl2classgraph}
\alias{jowl2classgraph}
\title{extract class relationship graph from JSON representation of OWL}
\usage{
jowl2classgraph(
  jsonpath,
  dropstrings = c("http://www.ifomis.org/bfo/1.1/snap#",
    "http://purl.org/autism-ontology/1.0/autism-rules.owl#")
)
}
\arguments{
\item{jsonpath}{character(1) path to JSON, typically generated by java robot applied to owl}

\item{dropstrings}{character(), strings to be excised from class names}
}
\value{
graphNEL with edgemode 'directed'
}
\description{
extract class relationship graph from JSON representation of OWL
}
\examples{
if (!requireNamespace("graph")) stop("install graph package from Bioconductor to use this function")
jpath = system.file("json", "aut.json.gz", package="ontoProc")
cg = jowl2classgraph(jpath,
  dropstrings = "http://purl.org/autism-ontology/1.0/autism-rules.owl#")
head(graph::nodes(cg))
}
