% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/runCVGMF.R
\name{calculateCVGMF}
\alias{calculateCVGMF}
\alias{runCVGMF}
\alias{calculateCVGMF,ANY-method}
\alias{calculateCVGMF,SummarizedExperiment-method}
\alias{calculateCVGMF,SingleCellExperiment-method}
\alias{calculateCVGMF,QFeatures-method}
\alias{runCVGMF,SummarizedExperiment-method}
\alias{runCVGMF,SingleCellExperiment-method}
\alias{runCVGMF,QFeatures-method}
\title{Perform a stochastic gradient descent generalized matrix factorization
(sgdGMF) on cells, based on the expression or mass spectrometry data in a
SingleCellExperiment, SummarizedExperiment or QFeatures object.}
\usage{
calculateCVGMF(x, ...)

runCVGMF(x, ...)

\S4method{calculateCVGMF}{ANY}(
  x,
  family = gaussian(),
  ncomponents = seq(1, 10, 1),
  ntop = NULL,
  X = NULL,
  Z = NULL,
  offset = NULL,
  weights = NULL,
  subset_row = NULL,
  scale = FALSE,
  transposed = FALSE,
  BSPARAM = bsparam(),
  BPPARAM = SerialParam(),
  control.init = list(),
  control.alg = list(),
  control.cv = list(),
  penalty = list(),
  method = "sgd",
  sampling = "block"
)

\S4method{calculateCVGMF}{SummarizedExperiment}(
  x,
  ...,
  exprs_values = 1,
  assay.type = exprs_values,
  family = gaussian()
)

\S4method{calculateCVGMF}{SingleCellExperiment}(
  x,
  ...,
  exprs_values = 1,
  dimred = NULL,
  n_dimred = NULL,
  assay.type = exprs_values,
  family = gaussian()
)

\S4method{calculateCVGMF}{QFeatures}(
  x,
  ...,
  exprs_values = NULL,
  dimred = NULL,
  n_dimred = NULL,
  assay.type = NULL
)

\S4method{runCVGMF}{SummarizedExperiment}(x, ...)

\S4method{runCVGMF}{SingleCellExperiment}(x, ..., altexp = NULL, name = "cv_GMF")

\S4method{runCVGMF}{QFeatures}(x, ..., exprs_values = NULL, assay.type = NULL)
}
\arguments{
\item{x}{For \code{calculateCVGMF}, a numeric matrix of expression counts
or mass spectrometry intensities where rows are features and columns are
cells.

Alternatively, a \link[SummarizedExperiment]{SummarizedExperiment-class},
\link[SingleCellExperiment]{SingleCellExperiment-class} or
\link[QFeatures]{QFeatures} object
containing such a matrix.}

\item{...}{For the \code{calculateCVGMF} generic, additional arguments to
pass to specific methods.
For the SummarizedExperiment and SingleCellExperiment methods, additional
arguments to pass to the ANY method. For the QFeatures method, additional
arguments to pass to the SingleCellExperiment method.

For \code{runCVGMF}, additional arguments to pass to \code{calculateCVGMF}.}

\item{family}{The distribution family that is used for the estimation of
the parameters.}

\item{ncomponents}{Numeric vector indicating the different number of
components used in cross-validation.}

\item{ntop}{Numeric scalar specifying the number of features with the
highest variances to use for dimensionality reduction. Default uses all
features.}

\item{X}{Sample-level covariate matrix. Defaults to column of ones.}

\item{Z}{Feature-level covariate matrix. Defaults to column of ones.}

\item{offset}{offset matrix with same dimensions as x that is added to the
linear predictor. Note that if family = poisson(),
this should therefore be on the log-scale.}

\item{weights}{weight matrix with same dimensions as x that determines the
weight of each observation.}

\item{subset_row}{Vector specifying the subset of features to use for
dimensionality reduction. This can be a character vector of row names, an
integer vector of row indices or a logical vector.}

\item{scale}{Logical scalar, should the expression values be standardized?
Not recommended for non-Gaussian data.}

\item{transposed}{Logical scalar, is \code{x} transposed with cells in rows?}

\item{BSPARAM}{A \link[BiocSingular]{BiocSingularParam-class} object
specifying which algorithm should be used to perform the PCA.
This is used in \code{\link[scater]{runPCA}} to put all information in the
sample latent factors.}

\item{BPPARAM}{A \link[BiocParallel]{BiocParallelParam-class} object
specifying whether
the cross-validation should be parallelized. If BPPARAM$workers > 1 and
control.cv$parallel and control.cv$nthreads are
not specified, parallelization is enabled with nthreads = BPPARAM$workers.}

\item{control.init}{control parameters for the initialization, used in the
\code{sgdGMF} package. See \link[sgdGMF]{sgdgmf.init} and
\link[sgdGMF]{set.control.init}.}

\item{control.alg}{control parameters for the estimation, used in the
\code{sgdGMF} package. See \link[sgdGMF]{sgdgmf.fit} and
\link[sgdGMF]{set.control.alg}.}

\item{control.cv}{control parameters for the cross-validation, used in the
\code{sgdGMF} package. See \link[sgdGMF]{sgdgmf.cv} and
\link[sgdGMF]{set.control.cv}.}

\item{penalty}{ridge penalty added for the estimation of the parameters in
the \code{sgdGMF} package. see \link[sgdGMF]{sgdgmf.fit}.}

\item{method}{estimation algorithm from the \code{sgdGMF} package used.
See \link[sgdGMF]{sgdgmf.fit}.}

\item{sampling}{sub-sampling strategy to use if method = "sgd".
See \link[sgdGMF]{sgdgmf.fit} from the \code{sgdGMF} package.}

\item{exprs_values}{Alias to \code{assay.type}.}

\item{assay.type}{Integer scalar or string indicating which assay of
\code{x} contains the values of interest.}

\item{dimred}{String or integer scalar specifying the existing
dimensionality reduction results to use.}

\item{n_dimred}{Integer scalar or vector specifying the dimensions to use
if \code{dimred} is specified.}

\item{altexp}{String or integer scalar specifying an alternative experiment
containing the input data.}

\item{name}{String specifying the name to be used to store the result in
the \code{\link[SingleCellExperiment]{reducedDims}} of the output.}
}
\value{
For \code{calculateCVGMF}, A table containing the summary statistics of
the cross-validation.

For \code{runCVGMF}, a SingleCellExperiment object is returned containing
this table in the metadata of this object.
}
\description{
Perform a stochastic gradient descent generalized matrix factorization
(sgdGMF) on cells, based on the expression or mass spectrometry data in a
SingleCellExperiment, SummarizedExperiment or QFeatures object.
}
\details{
sgdGMF uses sampling of the data to estimate the parameters, which can
alter with different seeds. Also, cross-validation
puts a random selection of values to missing. This means that the result
will change slightly across different runs.
For full reproducibility, users should call \code{\link{set.seed}} prior to
running \code{\link{runGMF}} with such algorithms.
(Note that this includes \code{BSPARAM=\link[BiocSingular]{bsparam}()},
which uses approximate algorithms by default.)

For feature selection and using alternative Experiments, see
\code{\link{runGMF}}.
}
\examples{
example_sce <- mockSCE(ncells = 200, ngenes = 100)
example_sce <- runCVGMF(example_sce,
                         exprs_values="counts",
                         family = poisson(),
                         ncomponents = c(1:5))
head(metadata(example_sce)[["cv_GMF"]])
example_sce <- runGMF(example_sce,
                      exprs_values="counts",
                      family = poisson(),
                      ncomponents = 3)
reducedDimNames(example_sce)
head(reducedDim(example_sce))
}
\seealso{
\code{\link[sgdGMF]{sgdgmf.cv}}, for the underlying calculations.
}
\author{
Alexandre Segers
}
