% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotGMF.R
\name{plotGMF}
\alias{plotGMF}
\title{Wrapper functions to create plots for specific types of reduced dimension
results in a SingleCellExperiment object, similar as the \code{scater}
package.}
\usage{
plotGMF(object, ..., ncomponents = 2, dimred = "GMF")
}
\arguments{
\item{object}{A \link[SingleCellExperiment]{SingleCellExperiment-class}
object.}

\item{...}{Additional arguments to pass to
\code{\link[scater]{plotReducedDim}}
from the \code{scater} package.}

\item{ncomponents}{Numeric scalar indicating the number of dimensions
components to (calculate and) plot. This can also be a numeric vector,
see \code{\link[scater]{plotReducedDim}} for details}

\item{dimred}{A string or integer scalar indicating the reduced dimension
result in \code{\link[SingleCellExperiment]{reducedDims}}(object) to plot.}
}
\value{
A \code{\link[ggplot2]{ggplot}} object.
}
\description{
Wrapper functions to create plots for specific types of reduced dimension
results in a SingleCellExperiment object, similar as the \code{scater}
package.
}
\details{
This is a wrapper around \code{\link[scater]{plotReducedDim}} that
uses the "GMF" slot from the \code{\link[SingleCellExperiment]{reducedDims}}
to obtain a dimensionality reduction plot.
}
\examples{
example_sce <- mockSCE(ncells = 200, ngenes = 100)
example_sce <- runCVGMF(example_sce,
                         exprs_values="counts",
                         family = poisson(),
                         ncomponents = c(1:5))
example_sce <- runGMF(example_sce,
                      exprs_values="counts",
                      family = poisson(),
                      ncomponents = 3)
plotGMF(example_sce)
}
\seealso{
\code{\link[scater]{plotReducedDim}}, for the underlying calculations.
\code{\link[scater]{plotPCA}}, for a similar wrapper.
}
\author{
Alexandre Segers
}
