% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/imputeGMF.R
\name{imputeGMF}
\alias{imputeGMF}
\alias{imputeGMF,ANY-method}
\alias{imputeGMF,SummarizedExperiment-method}
\alias{imputeGMF,SingleCellExperiment-method}
\alias{imputeGMF,QFeatures-method}
\title{Impute missing values based on the results of runGMF.}
\usage{
imputeGMF(x, ...)

\S4method{imputeGMF}{ANY}(x, sgdGMF_reducedDims)

\S4method{imputeGMF}{SummarizedExperiment}(
  x,
  sgdGMF_reducedDims,
  exprs_values = 1,
  assay.type = exprs_values,
  name = "imputedAssay"
)

\S4method{imputeGMF}{SingleCellExperiment}(
  x,
  reducedDimName = "GMF",
  sgdGMF_reducedDims = reducedDim(x, reducedDimName),
  exprs_values = 1,
  assay.type = exprs_values,
  name = "imputedAssay"
)

\S4method{imputeGMF}{QFeatures}(
  x,
  ...,
  reducedDimName = "GMF",
  exprs_values = NULL,
  assay.type = NULL,
  name = "imputedAssay"
)
}
\arguments{
\item{x}{a numeric matrix of expression counts or mass spectrometry
intensities containing missing values and with features in the rows and
samples in columns.

Alternatively, a
\link[SummarizedExperiment]{SummarizedExperiment-class},
\link[SingleCellExperiment]{SingleCellExperiment-class} or
\link[QFeatures]{QFeatures} object containing such a matrix.}

\item{...}{For the \code{imputeGMF} generic, additional arguments to
pass to specific methods.}

\item{sgdGMF_reducedDims}{the output obtained by \code{\link{runGMF}} or
\code{\link{calculateGMF}}. If \code{x} is a
\link[SingleCellExperiment]{SingleCellExperiment-class},
\code{sgdGMF_reducedDims} is taken
from \code{\link[SingleCellExperiment]{reducedDim}(x, reducedDimName)}.}

\item{exprs_values}{Alias to \code{assay.type}.}

\item{assay.type}{Integer scalar or string indicating which assay of
\code{x} contains the values of interest.}

\item{name}{New assay name included for the matrix with imputed values.}

\item{reducedDimName}{the name of the
\code{\link[SingleCellExperiment]{reducedDim}} slot corresponding to the
dimensionality reduction obtained with runGMF when
\code{x} is a \link[SingleCellExperiment]{SingleCellExperiment-class} or
\link[QFeatures]{QFeatures} object.}
}
\value{
For \link[SummarizedExperiment]{SummarizedExperiment-class},
\link[SingleCellExperiment]{SingleCellExperiment-class}
or \link[QFeatures]{QFeatures}, a similar
object now containing an extra assay with the imputed values.

For a matrix, a matrix with missing values imputed.
}
\description{
Impute missing values based on the results of runGMF.
}
\details{
Imputation is only possible after running \code{runGMF} using all features.
Therefore, \code{subset_row} or \code{ntop} should be set to NULL when
performing the matrix factorization.
}
\examples{
example_sce <- mockSCE(ncells = 200, ngenes = 100)
example_sce <- logNormCounts(example_sce)
assay(example_sce, 'logcounts')[assay(example_sce, 'logcounts') == 0] <- NA
example_sce <- runGMF(example_sce,
                      exprs_values="logcounts",
                      family = gaussian(),
                      ncomponents = 3)
example_sce <- imputeGMF(example_sce)
}
\seealso{
\code{\link{runGMF}}, to conveniently obtain the matrix factorization.
}
\author{
Alexandre Segers
}
