% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/writeHtmlReport.R
\name{writeHtmlReport}
\alias{writeHtmlReport}
\title{Write an HTML Summary Report}
\usage{
writeHtmlReport(
  fastqcDir,
  template,
  outDir,
  usePlotly = TRUE,
  species = "Hsapiens",
  gcType = c("Genome", "Transcriptome"),
  nOver = 30,
  targetsDF,
  overwrite = FALSE,
  quiet = TRUE
)
}
\arguments{
\item{fastqcDir}{A directory containing zipped, or extracted FastQC reports}

\item{template}{The template file which will be copied into \code{fastqcDir}}

\item{outDir}{The directory to write the compiled document to}

\item{usePlotly}{Generate interactive plots?}

\item{species}{Species/closely related species of sequenced samples}

\item{gcType}{Is the data "Transcriptomic" or "Genomic" in nature?}

\item{nOver}{The maximum number of Overrepresented Sequences to show}

\item{targetsDF}{A data.frame with at least two columns named
\code{Filename}  and \code{Label}.
The filenames should match the original fastq files, and the labels should
be simply alternative labels for these files for convenience.}

\item{overwrite}{\code{logical}. Overwrite any previous copies of the
template file in the destination directory}

\item{quiet}{\code{logical}. Show or hide markdown output in the Console.}
}
\value{
Silently returns \code{TRUE} and will output a compiled HTML file from the
supplied Rmarkdown template file
}
\description{
Compiles an HTML report using a supplied template
}
\details{
This will take a user supplied template, or the file supplied with the
package and create an HTML summary of all standard FASTQC plots for all
files in the supplied directory.
}
\examples{
\dontrun{
packageDir <- system.file("extdata", package = "ngsReports")
fileList <- list.files(packageDir, pattern = "fastqc.zip", full.names= TRUE)
# Copy these files to tempdir() to avoid overwriting
# any files in the package directory
file.copy(fileList, tempdir(), overwrite = TRUE)
writeHtmlReport(fastqcDir = tempdir())
}

}
