% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotNContent.R
\docType{methods}
\name{plotNContent}
\alias{plotNContent}
\alias{plotNContent,ANY-method}
\alias{plotNContent,FastqcData-method}
\alias{plotNContent,FastqcDataList-method}
\alias{plotNContent,FastpData-method}
\alias{plotNContent,FastpDataList-method}
\title{Draw an N Content Plot}
\usage{
plotNContent(x, usePlotly = FALSE, labels, pattern = ".(fast|fq|bam).*", ...)

\S4method{plotNContent}{ANY}(x, usePlotly = FALSE, labels, pattern = ".(fast|fq|bam).*", ...)

\S4method{plotNContent}{FastqcData}(
  x,
  usePlotly = FALSE,
  labels,
  pattern = ".(fast|fq|bam).*",
  pwfCols,
  warn = 5,
  fail = 20,
  showPwf = TRUE,
  ...,
  lineCol = "red"
)

\S4method{plotNContent}{FastqcDataList}(
  x,
  usePlotly = FALSE,
  labels,
  pattern = ".(fast|fq|bam).*",
  pwfCols,
  warn = 5,
  fail = 20,
  showPwf = TRUE,
  cluster = FALSE,
  dendrogram = FALSE,
  heat_w = 8,
  scaleFill = NULL,
  ...
)

\S4method{plotNContent}{FastpData}(
  x,
  usePlotly = FALSE,
  labels,
  pattern = ".(fast|fq|bam).*",
  module = c("Before_filtering", "After_filtering"),
  moduleBy = c("facet", "colour", "linetype"),
  reads = c("read1", "read2"),
  readsBy = c("facet", "colour", "linetype"),
  scaleColour = NULL,
  scaleLine = NULL,
  plotTheme = theme_get(),
  plotlyLegend = FALSE,
  ...
)

\S4method{plotNContent}{FastpDataList}(
  x,
  usePlotly = FALSE,
  labels,
  pattern = ".(fast|fq|bam).*",
  module = c("Before_filtering", "After_filtering"),
  reads = c("read1", "read2"),
  scaleFill = NULL,
  plotTheme = theme_get(),
  cluster = FALSE,
  dendrogram = FALSE,
  heat_w = 8,
  ...
)
}
\arguments{
\item{x}{Can be a \code{FastqcData}, \code{FastqcDataList} or file paths}

\item{usePlotly}{\code{logical}. Output as ggplot2 (default) or plotly
object.}

\item{labels}{An optional named vector of labels for the file names.
All filenames must be present in the names.}

\item{pattern}{Regex used to trim the end of filenames}

\item{...}{Used to pass additional attributes to theme() for FastqcData
objects and to geom* calls for FastpData-based objects}

\item{pwfCols}{Object of class \code{\link[=PwfCols]{PwfCols()}} containing the colours
for PASS/WARN/FAIL}

\item{warn, fail}{The default values for warn and fail are 5 and 10
respectively (i.e. percentages)}

\item{showPwf}{logical(1) Show the PASS/WARN/FAIL status}

\item{lineCol}{Line colours}

\item{cluster}{\code{logical} default \code{FALSE}. If set to \code{TRUE},
fastqc data will be clustered using hierarchical clustering}

\item{dendrogram}{\code{logical} redundant if \code{cluster} is \code{FALSE}
if both \code{cluster} and \code{dendrogram} are specified as \code{TRUE}
then the dendrogram will be displayed.}

\item{heat_w}{Relative width of any heatmap plot components}

\item{scaleFill, scaleColour, scaleLine}{ggplot2 scale objects}

\item{module}{Used for Fastp* structures to show results before or after
filtering}

\item{moduleBy, readsBy}{How to show each module or set of reads on the plot}

\item{reads}{Show plots for read1, read2 or both.}

\item{plotTheme}{\link[ggplot2]{theme} object}

\item{plotlyLegend}{logical(1) Show legend on interactive plots}
}
\value{
A standard ggplot2 object, or an interactive plotly object
}
\description{
Draw an N Content Plot across one or more FastQC reports
}
\details{
This extracts the N_Content from the supplied object and generates a ggplot2
object, with a set of minimal defaults.
The output of this function can be further modified using the standard
ggplot2 methods.

When \code{x} is a single FastqcData object line plots will always be drawn
for all Ns.
Otherwise, users can select line plots or heatmaps.
}
\examples{

## Using a Fastp Data object
fl <- system.file("extdata/fastp.json.gz", package = "ngsReports")
fp <- FastpData(fl)
plotNContent(fp)
plotNContent(
  fp, pattern = "_001.+",
  moduleBy = "colour", scaleColour = scale_colour_brewer(palette = "Set1"),
  plotTheme = theme(
    legend.position = 'inside', legend.position.inside = c(0.99, 0.99),
    legend.justification = c(1, 1), plot.title = element_text(hjust = 0.5)
  )
)

}
