% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{gcTheoretical}
\alias{gcTheoretical}
\title{Theoretical GC content}
\format{
An object of class \code{TheoreticalGC} of length 1.
}
\usage{
gcTheoretical
}
\description{
This object contains the theoretical GC content for each
provided species, for both the genome and transcriptome, where available.
}
\details{
The object is defined with the S4 class \code{TheoreticalGC}.
Species for which information is available can be found using
the command \code{gcAvail(gcTheoretical)} and selecting the appropriate type.

Metadata is accessible using \code{mData(gcTheoretical)}.

All GC content was calculated using code from
https://github.com/mikelove/fastqcTheoreticalGC using BSgenome packages.
This provides a default set of GC content data for common organisms
generated using 100bp reads/fragments and 1e6 reads.
}
\examples{
## Check which genomes are included
gcAvail(gcTheoretical, "Genome")

## Check which transcriptomes are included
gcAvail(gcTheoretical, "Transcriptome")


}
\seealso{
gcAvail
}
\keyword{datasets}
