% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{.makeLabels}
\alias{.makeLabels}
\title{Perform the checks and return the labels}
\usage{
.makeLabels(
  x,
  labels,
  pattern = ".(fast|fq|bam|sam|cram).*",
  col = "Filename",
  ...
)
}
\arguments{
\item{x}{A data.frame with a column titled "Filename"}

\item{labels}{Named vector of labels for plotting}

\item{pattern}{character Regular expression to remove from filenames}

\item{col}{character Column to use for generating labels}

\item{...}{Not used}
}
\value{
Named character vector
}
\description{
Checks for the presence of labels and returns defaults
}
\details{
Takes a named vector of labels and checks for the correct fields.
If no vector is supplied, returns the file names missing the specified
pattern, which defaults to removing the suffixes fastq(.gz), fq(.gz),
bam, sam or cram.
}
\examples{
f <- paste0(c("File1", "File2"), ".fastq")
df <- data.frame(Filename = f, stringsAsFactors = FALSE)
ngsReports:::.makeLabels(df)

}
\keyword{internal}
