#!/bin/bash 
#------------------

# http://proteowizard.svn.sourceforge.net/viewvc/proteowizard/trunk/pwiz/libraries/boost_aux/boost/utility/

cd src

if /bin/false ; then
#------------------
    
rm -rf pwiz
mkdir pwiz
cd pwiz

PWIZREPO=http://svn.code.sf.net/p/proteowizard/code/trunk/pwiz/
svn co --non-recursive $PWIZREPO .

for DIR in data/msdata data/identdata data/proteome data/common utility/chemistry/ utility/misc/ utility/math/ utility/minimxml/ ; do 
    svn co $PWIZREPO/pwiz/$DIR $DIR
done

cd ..

#------------------

rm -rf boost

BOOSTVER=1_58_0
BOOSTVERDOT=1.58.0
BOOSTURL=https://freefr.dl.sourceforge.net/project/boost/boost/$BOOSTVERDOT/boost_$BOOSTVER.tar.gz

wget -O- "$BOOSTURL" | tar xzvf -

mv boost_$BOOSTVER boost
           
#------------------

rm -rf boost_aux
mkdir boost_aux
cd boost_aux

PWIZBOOSTREPO=http://svn.code.sf.net/p/proteowizard/code/trunk/pwiz/libraries/boost_aux/boost/
svn co $PWIZBOOSTREPO boost

cd ..

#------------------
fi 
#------------------


PWIZ_MAJOR=$(grep "constant PWIZ_MAJOR" pwiz/Jamroot.jam | sed -e 's/constant PWIZ_MAJOR : \([0-9+]\) ;/\1/')
PWIZ_MINOR=$(grep "constant PWIZ_MINOR" pwiz/Jamroot.jam | sed -e 's/constant PWIZ_MINOR : \([0-9+]\) ;/\1/')

#lastchangedrev=$(svn info pwiz/data/msdata | grep "Last Changed Rev:" | cut -d: -f 2)
#lastchangeddate=$(svn info pwiz/data/msdata | grep "Last Changed Date:" | cut -d" " -f 4 | tr "-" " ")
lastchangedrev=666
lastchangeddate="1016-03-22"
revisioninfo=( $lastchangedrev $lastchangeddate 3 4 )
echo ${revisioninfo[*]}

cat >pwiz/data/msdata/Version.cpp <<EOF
// This file was generated by the \"svnrev\" utility
// You should not modify it manually, as it may be re-generated.
//
// $Revision: ${revisioninfo[1]} $
// $Date: ${revisioninfo[2]}-${revisioninfo[3]}-${revisioninfo[4]} $
//

#define PWIZ_SOURCE
#include "Version.hpp"
#include <sstream>

#ifdef PWIZ_USER_VERSION_INFO_H // in case you need to add any info version of your own
#include PWIZ_USER_VERSION_INFO_H  // must define PWIZ_USER_VERSION_INFO_H_STR for use below
#endif

namespace pwiz {
namespace msdata {

using std::string;

int Version::Major()                {return 0${PWIZ_MAJOR};}
int Version::Minor()                {return 0${PWIZ_MINOR};}
int Version::Revision()             {return 0${revisioninfo[1]};}
string Version::LastModified()      {return "${revisioninfo[2]}-${revisioninfo[3]}-${revisioninfo[4]}";}
string Version::str()               
{
	std::ostringstream v;
	v << Major() << '.' << Minor() << '.' << Revision();
#ifdef PWIZ_USER_VERSION_INFO_H
	v << " (" << PWIZ_USER_VERSION_INFO_H_STR << ")";
#endif
	return v.str();
}
}
}
EOF

#------------------


PWIZ_MAJOR=$(grep "constant PWIZ_MAJOR" pwiz/Jamroot.jam | sed -e 's/constant PWIZ_MAJOR : \([0-9+]\) ;/\1/')
PWIZ_MINOR=$(grep "constant PWIZ_MINOR" pwiz/Jamroot.jam | sed -e 's/constant PWIZ_MINOR : \([0-9+]\) ;/\1/')

#lastchangedrev=$(svn info pwiz/data/msdata | grep "Last Changed Rev:" | cut -d: -f 2)
#lastchangeddate=$(svn info pwiz/data/msdata | grep "Last Changed Date:" | cut -d" " -f 4 | tr "-" " ")
lastchangedrev=666
lastchangeddate="1016-03-22"
revisioninfo=( $lastchangedrev $lastchangeddate 3 4 )
echo ${revisioninfo[*]}

cat >pwiz/data/identdata/Version.cpp <<EOF
// This file was generated by the \"svnrev\" utility
// You should not modify it manually, as it may be re-generated.
//
// $Revision: ${revisioninfo[1]} $
// $Date: ${revisioninfo[2]}-${revisioninfo[3]}-${revisioninfo[4]} $
//

#define PWIZ_SOURCE
#include "Version.hpp"
#include <sstream>

#ifdef PWIZ_USER_VERSION_INFO_H // in case you need to add any info version of your own
#include PWIZ_USER_VERSION_INFO_H  // must define PWIZ_USER_VERSION_INFO_H_STR for use below
#endif

namespace pwiz {
namespace identdata {

using std::string;

int Version::Major()                {return 0${PWIZ_MAJOR};}
int Version::Minor()                {return 0${PWIZ_MINOR};}
int Version::Revision()             {return 0${revisioninfo[1]};}
string Version::LastModified()      {return "${revisioninfo[2]}-${revisioninfo[3]}-${revisioninfo[4]}";}
string Version::str()               
{
	std::ostringstream v;
	v << Major() << '.' << Minor() << '.' << Revision();
#ifdef PWIZ_USER_VERSION_INFO_H
	v << " (" << PWIZ_USER_VERSION_INFO_H_STR << ")";
#endif
	return v.str();
}
}
}
EOF
