% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/countPwmMatches.R
\name{countPwmMatches}
\alias{countPwmMatches}
\title{Count the matches to a PWM within an XStringSet}
\usage{
countPwmMatches(
  pwm,
  stringset,
  rc = TRUE,
  min_score = "80\%",
  mc.cores = 1,
  ...
)
}
\arguments{
\item{pwm}{A Position Weight Matrix}

\item{stringset}{An XStringSet}

\item{rc}{logical(1) Also find matches using the reverse complement of pwm}

\item{min_score}{The minimum score to return a match}

\item{mc.cores}{Passed to \link[parallel]{mclapply} when analysing a list of
PWMs}

\item{...}{Passed to \link[Biostrings]{countPWM}}
}
\value{
An integer vector
}
\description{
Count the matches to a PWM within an XStringSet
}
\details{
Will simply count the matches within an XStringSet and return an integer.
All matches are included.
}
\examples{
## Load the example PWM
data("ex_pfm")
esr1 <- ex_pfm$ESR1

## Load the example Peaks
data("ar_er_seq")
countPwmMatches(esr1, ar_er_seq)

## Count all PWMs
countPwmMatches(ex_pfm, ar_er_seq)

}
