% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/plotBoxplot.R
\name{plotBoxplot}
\alias{plotBoxplot}
\alias{plotBoxplot,SummarizedExperiment-method}
\title{Create boxplot of \code{assay}, \code{rowData} or \code{colData}.}
\usage{
plotBoxplot(object, ...)

\S4method{plotBoxplot}{SummarizedExperiment}(
  object,
  assay.type = NULL,
  row.var = NULL,
  col.var = NULL,
  x = NULL,
  features = NULL,
  group.by = NULL,
  ...
)
}
\arguments{
\item{object}{a
\code{\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment}}
object.}

\item{...}{Additional parameters for plotting.
\itemize{
\item \code{point.offset}: \code{Character scalar}. Utilized method
for offsetting points. The available options include:
\code{"center"}, \code{"compactswarm"}, \code{"hex"}, \code{"square"},
\code{"swarm"}
(see \code{\link[beeswarm:beeswarm]{beeswarm::beeswarm()}} for details),
\code{"frowney"}, \code{"maxout"}, \code{"minout"}, \code{"pseudorandom"},
\code{"quasirandom"},  \code{"smiley"}, \code{"tukey"}, \code{"tukeyDense"}
(see \code{\link[vipor:offsetSingleGroup]{vipor::offsetSingleGroup()}}
for details), \code{"jitter"}, and \code{"none"},
If \code{"none"}, ofsetting is not applied. (Default: \code{"jitter"})

\item \code{colour.by}: \code{NULL} or \code{character scalar}. Specifies a
variable from \code{colData(x)} or \code{rowData(x)} which is used to
colour observations. (Default: \code{NULL})

\item \code{fill.by}: \code{NULL} or \code{character scalar}. Specifies a
variable from \code{colData(x)} or \code{rowData(x)} which is used to
colour observations. (Default: \code{NULL})

\item \code{size.by}: \code{NULL} or \code{character scalar}. Specifies a
variable from \code{colData(x)} or \code{rowData(x)} which is used to scale
observation points. (Default: \code{NULL})

\item \code{shape.by}: \code{NULL} or \code{character scalar}. Specifies a
variable from \code{colData(x)} or \code{rowData(x)} which is used to shape
observation points. (Default: \code{NULL})

\item \code{facet.by}: \code{NULL} or \code{character scalar}. Specifies a
variable from \code{colData(x)} or \code{rowData(x)} which is used to facet
or group observations. (Default: \code{NULL})

\item \code{pair.by}: \code{NULL} or \code{character scalar}. Specifies a
variable from \code{colData(x)} which is used to pair observation points.
(Default: \code{NULL})

\item \code{add.chance}: \code{Logical scalar}. Whether to visualize chance
of paired observations by the color of line. (Default: \code{FALSE})

\item \code{add.box}: \code{Logical scalar}. Whether to add a boxplot
layout. (Default: \code{TRUE})

\item \code{add.points}: \code{Logical scalar}. Whether to add a point
layout. (Default: \code{TRUE})

\item \code{add.proportion}: \code{Logical scalar}. Whether to add a
barplot layout denoting the proportion of observations above
\code{threshold}. (Default: \code{FALSE})

\item \code{add.threshold}: \code{Logical scalar}. Whether to add a
\code{threshold} as horizontal line when \code{add.proportion = TRUE} is
specified. (Default: \code{TRUE})

\item \code{threshold}: \code{Numeric scalar}. Specifies threshold for the
barplots. (Default: \code{0})

\item \code{jitter.width}: \code{Numeric scalar}. Width of jitter.
(Default: \code{0.3})

\item \code{jitter.height}: \code{Numeric scalar}. Height of jitter.
(Default: \code{0})

\item \code{dodge.width}: \code{Numeric scalar}. Width of dodge. How far
apart the groups are plotted? (Default: \code{0})

\item \code{beeswarm.corral}: \code{Character scalar}. Beeswarm's "corral"
method. Fed to function \code{beeswarm::beeswarm()}.
(Default: \code{"none"})

\item \code{scales}: \code{Character scalar}. Adjust scales of facets.
(Default: \code{"fixed"})

\item \code{box.alpha}: \code{Numeric scalar}. Transparency of the boxplot
layer. (Default: \code{0.5})

\item \code{point.alpha}: \code{Numeric scalar}. Transparency of the point
layer. (Default: \code{0.65})

\item \code{line.alpha}: \code{Numeric scalar}. Transparency of the line
layer. (Default: \code{0.5})

\item \code{point.shape}: \code{Numeric scalar}. Shape of points.
(Default: \code{21})

\item \code{point.size}: \code{Numeric scalar}. Size of points.
(Default: \code{2})

\item \code{point.colour}: \code{Character scalar}. Colour of points.
(Default: \code{"grey70"})

\item \code{linetype}: \code{Numeric scalar}. Type of lines.
(Default: \code{1})

\item \code{linewidth}: \code{Numeric scalar}. Width of lines.
(Default: \code{1})

\item \code{line.colour}: \code{Character scalar}. Colour of lines.
(Default: \code{"grey70"})

\item \code{box.width}: \code{Numeric scalar}. Width of boxes.
(Default: \code{0.75})

\item \code{bar.width}: \code{Numeric scalar}. Width of proportion bars.
By default, it is calculated based so that the width matches with the
width of boxes.
}}

\item{assay.type}{\code{NULL} or \code{character scalar}. Specifies the
abundace table to plot. (Default: \code{NULL})}

\item{row.var}{\code{NULL} or \code{character scalar}. Specifies a variable
from \code{rowData(x)} to visualize. (Default: \code{NULL})}

\item{col.var}{\code{NULL} or \code{character scalar} Specifies a variable
from \code{colData(x)} to visualize. (Default: \code{NULL})}

\item{x}{\code{NULL} or \code{character vector}. Specifies a variable
from \code{colData(x)} or \code{rowData(x)} to visualize in x axis.
(Default: \code{NULL})}

\item{features}{\code{NULL} or \code{character vector}. If \code{assay.type}
is specified, this specifies rows to visualize in different facets. If
\code{NULL}, whole data is visualized as a whole. (Default: \code{NULL})}

\item{group.by}{\code{NULL} or \code{character vector}. Specifies a variable
from \code{colData(x)} or \code{rowData(x)} to group observations.
(Default: \code{NULL})}
}
\value{
A \code{ggplot2} object.
}
\description{
This methods visualizes abundances or variables from \code{rowData} or
\code{colData}.
}
\details{
A box plot is standard visualization technique to compare numeric values,
such as abundance, between categorical values, such as sample groups.
\code{plotBoxplot()} streamlines creation of box plots, and it offers
multiple options for visualization.
}
\examples{
data("Tito2024QMP")
tse <- Tito2024QMP

tse <- transformAssay(tse, method = "relabundance")
tse <- addAlpha(tse, index = "shannon")

# Visualize alpha diversity
plotBoxplot(tse, col.var = "shannon", x = "diagnosis")

# Visualize relative abundance of top features
tse <- tse[getTop(tse, 6), ]

plotBoxplot(
    tse, assay.type = "relabundance",
    x = "diagnosis", fill.by = "diagnosis",
    features = rownames(tse), facet.by = "rownames"
)

# Add proportion bar
plotBoxplot(
    tse, assay.type = "relabundance",
    x = "diagnosis", fill.by = "diagnosis",
    features = rownames(tse), facet.by = "rownames",
    add.proportion = TRUE, threshold = 0.1
)

# Visualize only with beeswarm
plotBoxplot(
    tse, assay.type = "relabundance",
    x = "diagnosis", group.by = "diagnosis",
    colour.by = "colonoscopy",
    features = rownames(tse), facet.by = "rownames",
    point.offset = "swarm", add.box = FALSE
)

# Do not add points
plotBoxplot(
    tse, assay.type = "relabundance",
    fill.by = "diagnosis",
    features = rownames(tse), facet.by = "rownames",
    add.points = FALSE
)

\dontrun{
library(microbiomeDataSets)

mae <- microbiomeDataSets::peerj32()
tse <- getWithColData(mae, 1)
tse[["time_point"]] <- as.character(tse[["time"]])
# Create a plot showing chance between time points in abundance of
# Akkermansia
plotBoxplot(
    tse, x = "time_point", assay.type = "counts", fill.by = "group",
    features = "Akkermansia", pair.by = "subject",
    add.chance = TRUE, scales = "free"
)
}

}
\seealso{
\itemize{
\item \code{\link[scater:plotExpression]{scater::plotExpression}}
\item \code{\link[scater:plotRowData]{scater::plotRowData}}
\item \code{\link[scater:plotColData]{scater::plotColData}}
}
}
