% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pcaLoading2dPlot.R
\name{pcaLoading2dPlot}
\alias{pcaLoading2dPlot}
\title{Loading plots on a 2D scatter plot}
\usage{
pcaLoading2dPlot(
  resPcaBySvd,
  axes = c(1, 2),
  title = "PCA loading plot",
  addRownames = FALSE,
  pl_n = 10,
  metadata = NULL,
  drawOrigin = TRUE,
  ...
)
}
\arguments{
\item{resPcaBySvd}{A list corresponding to the output value of \code{\link{pcaBySvd}}.}

\item{axes}{A numerical vector of length 2 with the Principal Components axes to be drawn.}

\item{title}{Plot title.}

\item{addRownames}{Boolean indicating if the labels should be plotted. By default, uses the row names of the loadings matrix but it can be manually specified with the \code{points_labs} argument from \code{\link{plotScatter}}.}

\item{pl_n}{The number of labels that should be plotted, based on a distance measure (see Details).}

\item{metadata}{A \eqn{n \times k} "freely encoded" data.frame corresponding to the \code{design} argument in \code{\link{plotScatter}}.}

\item{drawOrigin}{if \code{TRUE}, draws horizontal and vertical intercepts at (0,0) based on the \code{\link{plotScatter}} function.}

\item{...}{Additional arguments to be passed to \code{\link{plotScatter}}.}
}
\value{
A \code{ggplot2} object with the PCA loading plot.
}
\description{
Produces 2D loading plots from \code{\link{pcaBySvd}} with the same graphical options as \code{\link{plotScatter}} as this is a wrapper of this function.
}
\details{
\code{pcaLoading2dPlot} is a wrapper of \code{\link{plotScatter}}. See \code{?plotScatter} for more information on the additional arguments.

The distance measure \eqn{d}{d} that is used to rank the variables is based on the following formula:
\deqn{d = \sqrt(P_{ab}^2*\lambda_{ab}^2)}{d = sqrt(P_ab^2 * lambda_ab^2)} where \eqn{a}{a}
and \eqn{b}{b} are two selected Principal Components, \eqn{P_{ab}}{P_ab} represents their
loadings and \eqn{\lambda_{ab}}{lambda_ab} their singular values.
}
\examples{

data("UCH")
ResPCA <- pcaBySvd(UCH$outcomes)

pcaLoading2dPlot(
  resPcaBySvd = ResPCA, axes = c(1, 2),
  title = "PCA loading plot UCH"
)

# adding color,  shape and labels to points
id_cit <- seq(446, 459)
id_hip <- c(seq(126, 156), seq(362, 375))
peaks <- rep("other", ncol(UCH$outcomes))
peaks[id_hip] <- "hip"
peaks[id_cit] <- "cit"
metadata <- data.frame(peaks)

pcaLoading2dPlot(
  resPcaBySvd = ResPCA, axes = c(1, 2),
  title = "PCA loading plot UCH", metadata = metadata,
  color = "peaks", shape = "peaks", addRownames = TRUE
)

# changing max.overlaps of ggrepel
options(ggrepel.max.overlaps = 30)
pcaLoading2dPlot(
  resPcaBySvd = ResPCA, axes = c(1, 2),
  title = "PCA loading plot UCH", metadata = metadata,
  color = "peaks", shape = "peaks", addRownames = TRUE,
  pl_n = 35
)

}
