% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lmpEffectMatrices.R
\name{lmpEffectMatrices}
\alias{lmpEffectMatrices}
\title{Computes the effect matrices}
\usage{
lmpEffectMatrices(resLmpModelMatrix, SS = TRUE, contrastList = NA)
}
\arguments{
\item{resLmpModelMatrix}{A list of 5 elements from \code{\link{lmpModelMatrix}}.}

\item{SS}{Logical. If \code{FALSE}, won't compute the percentage of variance for each effect.}

\item{contrastList}{A list of contrasts for each parameter. If \code{NA}, the function creates automatically the list by default.}
}
\value{
A list with the following elements:
\describe{
\item{\code{lmpDataList}}{The initial object: a list with outcomes, design and formula.}
\item{\code{modelMatrix}}{A \emph{nxp} model matrix specifically encoded for the ASCA-GLM method.}
\item{\code{modelMatrixByEffect}}{A list of \emph{F+1} model matrices for each effect.}
\item{\code{effectsNamesUnique}}{A character vector with the \emph{F+1} names of the model effects, each repeated once.}
\item{\code{effectsNamesAll}}{A character vector with the \emph{p} names of the model effects ordered and repeated as the column names of the model matrix.}
\item{\code{effectMatrices}}{A list of \emph{F+1} effect matrices for each model effect.}
\item{\code{predictedvalues}}{The \emph{nxm} matrix of predicted outcome values.}
\item{\code{residuals}}{The \emph{nxm} matrix of model residuals.}
\item{\code{parameters}}{The \emph{pxm} matrix of the estimated parameters.}
\item{\code{type3SS}}{A vector with the type III sum of squares for each model effect \emph{(If SS = TRUE)}.}
\item{\code{variationPercentages}}{A vector with the percentage of variance for each model effect \emph{(If SS = TRUE)}.}
\item{\code{varPercentagesPlot}}{A ggplot bar plot of the contributions of each model effect to the total variance \emph{(If SS = TRUE)}.}
}
}
\description{
Estimates the model by OLS based on the outcomes and model matrices provided in the outputs of lmpModelMatrix function and calculates the estimated effect matrices
\eqn{\hat{\mathbf{M}}_0, \hat{\mathbf{M}}_1, ...\hat{\mathbf{M}}_F}, ...  and residual matrix \eqn{\hat{\mathbf{E}}}.
It calculates also the type III percentage of variance explained by each effect.
}
\examples{
data("UCH")
resLmpModelMatrix <- lmpModelMatrix(UCH)
reslmpEffectMatrices <- lmpEffectMatrices(resLmpModelMatrix)
reslmpEffectMatrices$varPercentagesPlot

}
\references{
Thiel M.,Feraud B. and Govaerts B. (2017) \emph{ASCA+ and APCA+: Extensions of ASCA and APCA
in the analysis of unbalanced multifactorial designs}, Journal of Chemometrics
}
