% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lmpContributions.R
\name{lmpContributions}
\alias{lmpContributions}
\title{Summary of the contributions of each effect}
\usage{
lmpContributions(resLmpPcaEffects, nPC = 5)
}
\arguments{
\item{resLmpPcaEffects}{A list corresponding to the output value of \code{\link{lmpPcaEffects}}.}

\item{nPC}{The number of Principal Components to display.}
}
\value{
A list of:
\describe{
\item{\code{totalContribTable}}{Table of the percentage of contribution of each effect to the total variance.}
\item{\code{effectTable}}{Table of the percentage of variance explained by each principal component in each model effect decomposition.}
\item{\code{contribTable}}{Table of the percentage of variance explained by each principal component of each effect reported to the percentage contribution of the given effect to the total variance.}
\item{\code{combinedEffectTable}}{Equivalent of the \emph{EffectTable} for combined effects.}
\item{\code{plotTotal}}{Plot of the ordered contributions of \emph{TotalContribTable}.}
\item{\code{plotContrib}}{Plot of the ordered contributions of \emph{ContribTable}.}
}
}
\description{
Reports the contribution of each effect to the total variance,
but also the contribution of each PC to the total variance per effect.
These contributions are also summarized in a barplot.
}
\examples{
data("UCH")
resLmpModelMatrix <- lmpModelMatrix(UCH)
resLmpEffectMatrices <- lmpEffectMatrices(resLmpModelMatrix)
resLmpPcaEffects <- lmpPcaEffects(resLmpEffectMatrices, method = "ASCA-E")

lmpContributions(resLmpPcaEffects)

}
