% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/predictionProfile.R
\docType{methods}
\name{getPredictionProfile,BioVector-method}
\alias{getPredictionProfile}
\alias{getPredictionProfile,BioVector-method}
\alias{getPredictionProfile,XString-method}
\alias{getPredictionProfile,XStringSet-method}
\title{Calculation Of Predicition Profiles}
\usage{
\S4method{getPredictionProfile}{BioVector}(object, kernel, featureWeights, b,
  svmIndex = 1, sel = NULL, weightLimit = .Machine$double.eps)

\S4method{getPredictionProfile}{XStringSet}(object, kernel, featureWeights, b,
  svmIndex = 1, sel = NULL, weightLimit = .Machine$double.eps)

\S4method{getPredictionProfile}{XString}(object, kernel, featureWeights, b,
  svmIndex = 1, sel = NULL, weightLimit = .Machine$double.eps)
}
\arguments{
\item{object}{a single biological sequence in the form of an
\code{\linkS4class{DNAString}}, \code{\linkS4class{RNAString}} or
\code{\linkS4class{AAString}} or multiple biological sequences as
\code{\linkS4class{DNAStringSet}}, \code{\linkS4class{RNAStringSet}},
\code{\linkS4class{AAStringSet}} (or as \code{\linkS4class{BioVector}}).}

\item{kernel}{a sequence kernel object of class
\code{\linkS4class{SequenceKernel}}.}

\item{featureWeights}{a feature weights matrix retrieved from a KeBABS model
with the accessor \code{\link{featureWeights}}.}

\item{b}{model intercept from a KeBABS model.}

\item{svmIndex}{integer value selecting one of the pairwise SVMs in case of
pairwise multiclass classification. Default=1}

\item{sel}{subset of indices into \code{x} as integer vector. When this
parameter is present the prediction profiles are computed for the specified
subset of samples only. Default=\code{integer(0)}}

\item{weightLimit}{the feature weight limit is a single numeric value and
allows pruning of feature weights. All feature weights with an absolute
value below this limit are set to 0 and are not considered for the
prediction profile computation. This parameter is only relevant when
feature weights are calculated in KeBABS during training.
Default=.Machine$double.eps}
}
\value{
getPredictionProfile: upon successful completion, the function returns a set
of prediction profiles for the sequences as class
\code{\linkS4class{PredictionProfile}}.
}
\description{
compute prediction profiles for a given set of biological
sequences from a model trained with \code{kbsvm}
}
\details{
With this method prediction profiles can be generated explicitely for a
given set of sequences with a given model represented through its feature
weights and the model intercept b. A single prediction profile shows for
each position of the sequence the contribution of the patterns at this
position to the decision value. The prediciion profile also includes the
kernel object used for the generation of the profile and the seqence
data.\cr\cr
A single profile or a pair can be plotted with method \code{\link{plot}}
showing the relevance of sequence positions for the prediction. Please
consider that patterns occuring at neighboring sequence positions are not
statistically independent which means that the relevance of a specific
position is not only determined by the patterns at this position but is also
influenced by the neighborhood around this position. Prediction profiles can
also be generated implicitely during predction for the predicted samples
(see parameter \code{predProfiles} in \code{\link{predict}}).\cr\cr
}
\examples{
## set random generator seed to make the results of this example
## reproducable
set.seed(123)

## load coiled coil data
data(CCoil)
gappya <- gappyPairKernel(k=1,m=11, annSpec=TRUE)
model <- kbsvm(x=ccseq, y=as.numeric(yCC), kernel=gappya,
               pkg="e1071", svm="C-svc", cost=15)

## show feature weights
featureWeights(model)[,1:5]

## define two new sequences to be predicted
GCN4 <- AAStringSet(c("MKQLEDKVEELLSKNYHLENEVARLKKLV",
                      "MKQLEDKVEELLSKYYHTENEVARLKKLV"))
names(GCN4) <- c("GCN4wt", "GCN_N16Y,L19T")
## assign annotation metadata
annCharset <- annotationCharset(ccseq)
annot <- c("abcdefgabcdefgabcdefgabcdefga",
           "abcdefgabcdefgabcdefgabcdefga")
annotationMetadata(GCN4, annCharset=annCharset) <- annot

## compute prediction profiles
predProf <- getPredictionProfile(GCN4, gappya,
           featureWeights(model), modelOffset(model))

## show prediction profiles
predProf

## plot prediction profile of first aa sequence
plot(predProf, sel=1, ylim=c(-0.4, 0.2), heptads=TRUE, annotate=TRUE)

## plot prediction profile of both aa sequences
plot(predProf, sel=c(1,2), ylim=c(-0.4, 0.2), heptads=TRUE, annotate=TRUE)

## prediction profiles can also be generated during prediction
## when setting the parameter predProf to TRUE
## plotting longer sequences to pdf is shown in the examples for the
## plot function
}
\author{
Johannes Palme
}
\references{
\url{https://github.com/UBod/kebabs}\cr\cr
C.C. Mahrenholz, I.G. Abfalter, U. Bodenhofer, R. Volkmer and
S. Hochreiter (2011) Complex networks govern coiled coil
oligomerization - predicting and profiling by means of a machine
learning approach. \emph{Mol. Cell. Proteomics}, 10(5):M110.004994.
DOI: \doi{10.1074/mcp.M110.004994}. \cr\cr
U. Bodenhofer, K. Schwarzbauer, M. Ionescu, and
S. Hochreiter (2009).
Modelling position specificity in sequence kernels by fuzzy
equivalence relations. \emph{Proc. Joint 13th IFSA World Congress and 6th
EUSFLAT Conference}, pp. 1376-1381, Lisbon.\cr\cr
J. Palme, S. Hochreiter, and U. Bodenhofer (2015) KeBABS: an R package
for kernel-based analysis of biological sequences.
\emph{Bioinformatics}, 31(15):2574-2576.
DOI: \doi{10.1093/bioinformatics/btv176}.
}
\seealso{
\code{\linkS4class{PredictionProfile}}, \code{\link{predict}},
\code{\link{plot}}, \code{\link{featureWeights}},
\code{\link{getPredProfMixture}}
}
\keyword{feature}
\keyword{methods}
\keyword{prediction}
\keyword{profile}
\keyword{weights}

