% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{h_short_list}
\alias{h_short_list}
\title{Make a Short List of a Character Vector}
\usage{
h_short_list(x, sep = ", ", thresh = 3L)
}
\arguments{
\item{x}{(\code{character})\cr input which should be listed.}

\item{sep}{(\code{string})\cr separator to use.}

\item{thresh}{(\code{count})\cr threshold to use, if the length of \code{x} is larger
then the list will be shortened using the \code{...} ellipsis.}
}
\value{
String with the short list.
}
\description{
This helper function makes a short list string, e.g. "a, b, ..., z"
out of a character vector, e.g. \code{letters}.
}
\examples{
h_short_list(letters)
h_short_list(letters[1:3])
h_short_list(LETTERS[1:5], sep = ";", thresh = 5L)
}
