% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pca_cor_samplevar.R
\name{h_pca_df_r2_matrix}
\alias{h_pca_df_r2_matrix}
\title{Calculation of R2 Matrix between Sample Variables and Principal Components}
\usage{
h_pca_df_r2_matrix(pca, df)
}
\arguments{
\item{pca}{(\code{matrix})\cr comprises principal components generated by \code{\link[=calc_pca]{calc_pca()}}.}

\item{df}{(\code{data.frame})\cr from the \code{\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment::colData()}} of a
\code{\link{AnyHermesData}} object.}
}
\value{
A matrix with R2 values for all combinations of sample variables and principal
components.
}
\description{
This function processes sample variables from \code{\link{AnyHermesData}} and the
corresponding principal components matrix, and then generates the matrix of R2 values.
}
\details{
\itemize{
\item Note that only the \code{df} columns which are \code{numeric}, \code{character}, \code{factor} or
\code{logical} are included in the resulting matrix, because other variable types are not
supported.
\item In addition, \code{df} columns which are constant, all \code{NA}, or \code{character} or \code{factor}
columns with too many levels are also dropped before the analysis.
}
}
\examples{
object <- hermes_data \%>\%
  add_quality_flags() \%>\%
  filter() \%>\%
  normalize()

# Obtain the principal components.
pca <- calc_pca(object)$x

# Obtain the `colData` as a `data.frame`.
df <- as.data.frame(colData(object))

# Correlate them.
r2_all <- h_pca_df_r2_matrix(pca, df)
str(r2_all)

# We can see that only about half of the columns from `df` were
# used for the correlations.
ncol(r2_all)
ncol(df)
}
\seealso{
\code{\link[=h_pca_var_rsquared]{h_pca_var_rsquared()}} which is used internally to calculate the R2 for one
sample variable.
}
