% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/differential.R
\name{h_diff_expr_deseq2}
\alias{h_diff_expr_deseq2}
\title{\code{DESeq2} Differential Expression Analysis}
\usage{
h_diff_expr_deseq2(object, design, ...)
}
\arguments{
\item{object}{(\code{HermesData})\cr input.}

\item{design}{(\code{matrix})\cr design matrix.}

\item{...}{additional arguments internally passed to \code{\link[DESeq2:DESeq]{DESeq2::DESeq()}} (\code{fitType}, \code{sfType},
\code{minReplicatesForReplace}, \code{useT}, \code{minmu}).}
}
\value{
A data frame with columns \code{log2_fc} (estimated log2 fold change),
\code{stat} (Wald statistic), \code{p_val} (raw p-value), \code{adj_p_pval} (Benjamini-Hochberg adjusted p-value).
}
\description{
This helper functions performs the differential expression analysis with
\code{\link[DESeq2:DESeq]{DESeq2::DESeq()}} for a given \link{AnyHermesData} input and \code{design} matrix.
}
\examples{
object <- hermes_data

# Create the design matrix corresponding to the factor of interest.
design <- model.matrix(~SEX, colData(object))

# Then perform the `DESeq2` differential expression analysis.
result <- h_diff_expr_deseq2(object, design)
head(result)

# Change of the `fitType` can be required in some cases.
result2 <- h_diff_expr_deseq2(object, design, fitType = "local")
head(result2)
}
\references{
\insertRef{DESeq2_package}{hermes}
}
