% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{h_df_factors_with_explicit_na}
\alias{h_df_factors_with_explicit_na}
\title{Conversion to Factors with Explicit Missing Level in a \code{data.frame}}
\usage{
h_df_factors_with_explicit_na(data, na_level = "<Missing>")
}
\arguments{
\item{data}{(\code{data.frame})\cr input data with at least one column.}

\item{na_level}{(\code{string})\cr explicit missing level to be used.}
}
\value{
The modified data.
}
\description{
This helper function converts all character and logical variables
to factor variables in a \code{data.frame}. It also sets an explicit missing data level
for all factor variables that have at least one \code{NA}. Empty strings are handled
as \code{NA}.
}
\examples{
dat <- data.frame(
  a = c(NA, 2),
  b = c("A", NA),
  c = c("C", "D"),
  d = factor(c(NA, "X")),
  e = factor(c("Y", "Z"))
)
h_df_factors_with_explicit_na(dat)
}
