% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{colPrinComp1}
\alias{colPrinComp1}
\title{First Principal Component (PC1) Gene Signature}
\usage{
colPrinComp1(x, center = TRUE, scale = TRUE)
}
\arguments{
\item{x}{(\code{matrix})\cr containing numeric data with genes in rows and samples
in columns, no missing values are allowed.}

\item{center}{(\code{flag})\cr whether the variables should be zero centered.}

\item{scale}{(\code{flag})\cr whether the variables should be scaled to have unit variance.}
}
\value{
A numeric vector containing the principal component values for each
column in \code{x}.
}
\description{
This helper function returns the first principal component from an assay
stored as a \code{matrix}.
}
\examples{
object <- hermes_data \%>\%
  add_quality_flags() \%>\%
  filter() \%>\%
  normalize() \%>\%
  assay("counts")

colPrinComp1(object)
}
