% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_hilight.R
\name{geom_hilight}
\alias{geom_hilight}
\alias{geom_highlight}
\title{geom_hilight}
\usage{
geom_hilight(
  data = NULL,
  mapping = NULL,
  node = NULL,
  type = "auto",
  to.bottom = FALSE,
  ...
)

geom_highlight(
  data = NULL,
  mapping = NULL,
  node = NULL,
  type = "auto",
  to.bottom = FALSE,
  ...
)
}
\arguments{
\item{data}{data.frame, The data to be displayed in this layer, defaults to NULL.}

\item{mapping}{Set of aesthetic mappings, defaults to NULL.}

\item{node}{selected node to hilight, when data and mapping is NULL, it is required.}

\item{type}{the type of layer, defaults to \code{auto}, meaning rectangular, circular,
slanted, fan, inward_circular, radial, equal_angle, ape layout tree will use rectangular layer,
unrooted and daylight layout tree use will use encircle layer. You can specify this parameter to
\code{rect} (rectangular layer) or \code{encircle} (encircle layer), 'gradient' (gradient color),
'roundrect' (round rectangular layer).}

\item{to.bottom}{logical, whether set the high light layer to the bottom in all layers of 'ggtree'
object, default is FALSE.}

\item{...}{additional parameters, see also the below and Aesthetics section.
\itemize{
\item \code{align} control the align direction of the edge of high light rectangular.
Options is 'none' (default), 'left', 'right', 'both'. This argument only work when the
'geom_hilight' is plotting using geom_hilight(mapping=aes(...)).
\item \code{gradient.direction} character, the direction of gradient color, defaults to 'rt'
meaning the locations of gradient color is from root to tip, options are 'rt' and 'tr'.
\item \code{gradient.length.out} integer, desired length of the sequence of gradient color,
defaults to 2.
\item \code{roundrect.r} numeric, the radius of the rounded corners, when \code{roundrect=TRUE},
defaults to 0.05.
}}
}
\value{
a list object.
}
\description{
layer of hilight clade
}
\details{
\code{geom_hilight} supports data.frame as input. And aesthetics of layer can be mapped.
you can see the Aesthetics section to set parameters.
}
\section{Aesthetics}{

\code{geom_hilight()} understands the following aesthetics for rectangular layer (required
aesthetics are in bold):
\itemize{
\item \strong{\code{node}} selected node to hight light, it is required.
\item \code{colour} the colour of margin, defaults to NA.
\item \code{fill} the colour of fill, defaults to 'steelblue'.
\item \code{alpha} the transparency of fill, defaults to 0.5.
\item \code{extend} extend xmax of the rectangle, defaults to 0.
\item \code{extendto} specify a value, meaning the rectangle extend to, defaults to NULL.
\item \code{linetype} the line type of margin, defaults to 1.
\item \code{linewidth} the width of line of margin, defaults to 0.5.
}
\code{geom_hilight()} understands the following aesthethics for encircle layer (required
aesthetics are in bold):
\itemize{
\item \strong{\code{node}} selected node to hight light, it is required.
\item \code{colour} the colour of margin, defaults to 'black'.
\item \code{fill} the colour of fill, defaults to 'steelblue'.
\item \code{alpha} the transparency of fill, defaults to 0.5.
\item \code{expand} expands the xspline clade region, defaults to 0.
\item \code{spread} control the size, when only one point.
\item \code{linewidth} the width of line of margin, defaults to 0.5.
\item \code{linetype} the line type of margin, defaults to 1.
\item \code{s_shape} the shape of the spline relative to the control points, defaults to 0.5.
\item \code{s_open}  whether the spline is a line or a closed shape, defaults to FALSE.
}
}

\examples{
library(ggplot2)
set.seed(102)
tree <- rtree(60)
p <- ggtree(tree)
p1 <- p + geom_hilight(node=62) + geom_hilight(node=88, fill="red")
p1
dat <- data.frame(id=c(62, 88), type=c("A", "B"))
p2 <- p + geom_hilight(data=dat, mapping=aes(node=id, fill=type))
p2
p3 <- p + geom_hilight(data=dat, mapping=aes(node=id, fill=type), align="left")
p4 <- p + geom_hilight(data=dat, mapping=aes(node=id, fill=type), align="right")
p5 <- p + geom_hilight(data=dat, mapping=aes(node=id, fill=type), align="both")
# display the high light layer with gradiental color rectangular.
p6 <- p + geom_hilight(data=dat, mapping=aes(node=id, fill=type), type = "gradient", alpha=0.68)
p7 <- p + geom_hilight(data=dat, mapping=aes(node=id, fill=type), 
                      type = "gradient", gradient.direction="tr", alpha=0.68)
# display the high light layer with round rectangular.
p8 <- p + geom_hilight(data=dat, mapping=aes(node=id, fill=type), type = "roundrect", alpha=0.68)
p2/ p3/ p4/ p5 / p6/ p7/ p8
library(ggiraph)
f <- ggtree(tree, layout = 'daylight', mapping = aes(tooltip = round(branch.length, 2), data_id = node))
f1 <- f + geom_hilight(data=dat, mapping=aes(node=id, fill=type, tooltip = id, data_id = id), to.bottom = TRUE)
ff <- ggtree(tree, layout = 'circular', mapping = aes(tooltip = round(branch.length, 2), data_id = node))
ff1 <- ff + geom_hilight(data=dat, mapping=aes(node=id, fill=type, tooltip = id, data_id = id), to.bottom = TRUE)
girafe(ggobj = f1)
girafe(ggobj = ff1)
}
\references{
For more detailed demonstration, please refer to chapter 5.2.2 of
\emph{Data Integration, Manipulation and Visualization of Phylogenetic Trees}
\url{http://yulab-smu.top/treedata-book/index.html} by Guangchuang Yu.
}
\author{
Guangchuang Yu and Shuangbin Xu
}
