% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotMolecules.R
\name{plotMolecules}
\alias{plotMolecules}
\title{plotMolecules}
\usage{
plotMolecules(
  spe,
  molecule = NULL,
  x_coord = NULL,
  y_coord = NULL,
  sample_id = "sample_id",
  pal = c("gray90", "navy"),
  point_size = 0.3
)
}
\arguments{
\item{spe}{(SpatialExperiment) Input data, assumed to be a
\code{SpatialExperiment} object.}

\item{molecule}{Name of mRNA molecule to plot (assumed to match one of the
row names of \code{rowData}).}

\item{x_coord}{Name of column in \code{spatialCoords} containing x
coordinates. Default = NULL, which selects the first column of
\code{spatialCoords}.}

\item{y_coord}{Name of column in \code{spatialCoords} containing y
coordinates. Default = NULL, which selects the second column of
\code{spatialCoords}.}

\item{sample_id}{Name of column in \code{colData} containing sample IDs. This
argument is only required for datasets containing multiple samples (tissue
sections). If provided, samples will be shown in multiple panels using
facetting. Default = NULL.}

\item{pal}{Color palette, provided as a vector of length 2 for the low and
high range. Default = c("gray90", "navy").}

\item{point_size}{Point size. Default = 0.3.}
}
\value{
Returns a ggplot object, which may be further modified using ggplot
  functions.
}
\description{
Plotting functions for spatial transcriptomics data.
}
\details{
Function to create spot plot for molecule-based datasets, showing spatial
locations in x-y coordinates with optional annotations such as expression of
a gene.
}
\examples{
library(STexampleData)
spe <- seqFISH_mouseEmbryo()
plotMolecules(spe, molecule = "Sox2")

}
\author{
Lukas M. Weber
}
