% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cellClusters.R
\name{SRD}
\alias{SRD}
\title{Sequence Relabeling Distance}
\usage{
SRD(c1, c2, noise = 0)
}
\arguments{
\item{c1, c2}{The cluster sequence 1 and 2.}

\item{noise}{The noise cluster name. Default is 0.}
}
\value{
The mean value of hamming distance after label alignment.
}
\description{
Compares two cluster sequences after best label alignment.
}
\examples{
c1 <- c(-1, 0, 1, 1, -1, 3, 3, 5, 5, 5)   # `-1` is noise
c2 <- c(-1, 4, 4, 4, -1, 2, 2, 2, 2, 2)   # `-1` is noise
SRD(c1, c2, noise=-1)

}
