% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rglViewer.R
\name{rglViewer}
\alias{rglViewer}
\title{rgl Viewer
View the 3d structure by rgl.}
\usage{
rglViewer(..., background = "gray")
}
\arguments{
\item{...}{objects of threeJsGeometry.}

\item{background}{background of the main camera.}
}
\value{
MULL
}
\description{
rgl Viewer
View the 3d structure by rgl.
}
\examples{
obj <- readRDS(system.file("extdata", "4DNFI1UEG1HD.chr21.FLAMINGO.res.rds",
  package = "geomeTriD"
))
feature.gr <- readRDS(system.file("extdata", "4DNFI1UEG1HD.feature.gr.rds",
  package = "geomeTriD"
))
tjg <- view3dStructure(obj,
  k = 3, feature.gr = feature.gr, renderer = "none",
  length.arrow = grid::unit(0.000006, "native")
)
if(interactive()){
  rglViewer(tjg, background = 'white')
}

}
