% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatialDistanceMatrix.R
\name{autoK}
\alias{autoK}
\title{Automate Cluster Number Selection}
\usage{
autoK(d, hc, max_k)
}
\arguments{
\item{d}{A dist object.}

\item{hc}{A hclust object.}

\item{max_k}{The maximal k.}
}
\value{
The best k number.
}
\description{
Automate cluster number selection using Silhouette Width
}
\examples{
x <- matrix(rnorm(100), nrow = 5)
d <- dist(x)
hc <- hclust(d)
autoK(d, hc)
}
