% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allEndpoints.R
\name{get_datasets}
\alias{get_datasets}
\title{Retrieve all datasets}
\usage{
get_datasets(
  query = NA_character_,
  filter = NA_character_,
  taxa = NA_character_,
  uris = NA_character_,
  offset = 0L,
  limit = 20L,
  sort = "+id",
  raw = getOption("gemma.raw", FALSE),
  memoised = getOption("gemma.memoised", FALSE),
  file = getOption("gemma.file", NA_character_),
  overwrite = getOption("gemma.overwrite", FALSE)
)
}
\arguments{
\item{query}{The search query. Queries can include plain text or ontology
terms They also support conjunctions ("alpha AND beta"), disjunctions ("alpha OR beta")
grouping ("(alpha OR beta) AND gamma"), prefixing ("alpha*"), wildcard characters
("BRCA?") and fuzzy matches ("alpha~").}

\item{filter}{Filter results by matching expression. Use \code{\link{filter_properties}}
function to get a list of all available parameters. These properties can be
combined using "and" "or" clauses and may contain common operators such as "=", "<" or "in".
(e.g. "taxon.commonName = human", "taxon.commonName in (human,mouse), "id < 1000")}

\item{taxa}{A vector of taxon common names (e.g. human, mouse, rat). Providing multiple
species will return results for all species. These are appended
to the filter and equivalent to filtering for \code{taxon.commonName} property}

\item{uris}{A vector of ontology term URIs. Providing multiple terms will
return results containing any of the terms and their children. These are
appended to the filter and equivalent to filtering for \code{allCharacteristics.valueUri}}

\item{offset}{The offset of the first retrieved result.}

\item{limit}{Defaults to 20. Limits the result to specified amount
of objects. Has a maximum value of 100. Use together with \code{offset} and
the \code{totalElements} \link[base:attributes]{attribute} in the output to
compile all data if needed.}

\item{sort}{Order results by the given property and direction. The '+' sign
indicate ascending order whereas the '-' indicate descending.}

\item{raw}{\code{TRUE} to receive results as-is from Gemma, or \code{FALSE} to enable
parsing. Raw results usually contain additional fields and flags that are
omitted in the parsed results.}

\item{memoised}{Whether or not to save to cache for future calls with the
same inputs and use the result saved in cache if a result is already saved.
Doing \code{options(gemma.memoised = TRUE)} will ensure that the cache is always
used. Use \code{\link{forget_gemma_memoised}} to clear the cache.}

\item{file}{The name of a file to save the results to, or \code{NULL} to not write
results to a file. If \code{raw == TRUE}, the output will be the raw endpoint from the
API, likely a JSON or a gzip file. Otherwise, it will be a RDS file.}

\item{overwrite}{Whether or not to overwrite if a file exists at the specified
filename.}
}
\value{
A data table with information about the queried dataset(s). A list if
\code{raw = TRUE}. Returns an empty list if no datasets matched.

The fields of the output data.table are:

\itemize{
\item \code{experiment.shortName}: Shortname given to the dataset within Gemma. Often corresponds to accession ID
\item \code{experiment.name}: Full title of the dataset
\item \code{experiment.ID}: Internal ID of the dataset.
\item \code{experiment.description}: Description of the dataset
\item \code{experiment.troubled}: Did an automatic process within gemma or a curator mark the dataset as "troubled"
\item \code{experiment.accession}: Accession ID of the dataset in the external database it was taken from
\item \code{experiment.database}: The name of the database where the dataset was taken from
\item \code{experiment.URI}: URI of the original database
\item \code{experiment.sampleCount}: Number of samples in the dataset
\item \code{experiment.batchEffectText}: A text field describing whether the dataset has batch effects
\item \code{experiment.batchCorrected}: Whether batch correction has been performed on the dataset.
\item \code{experiment.batchConfound}: 0 if batch info isn't available, -1 if batch counfoud is detected, 1 if batch information is available and no batch confound found
\item \code{experiment.batchEffect}: -1 if batch p value < 0.0001, 1 if batch p value > 0.1, 0 if otherwise and when there is no batch information is available or when the data is confounded with batches.
\item \code{experiment.rawData}: -1 if no raw data available, 1 if raw data was available. When available, Gemma reprocesses raw data to get expression values and batches
\item \code{geeq.qScore}: Data quality score given to the dataset by Gemma.
\item \code{geeq.sScore}: Suitability score given to the dataset by Gemma. Refers to factors like batches, platforms and other aspects of experimental design
\item \code{taxon.name}: Name of the species
\item \code{taxon.scientific}: Scientific name for the taxon
\item \code{taxon.ID}: Internal identifier given to the species by Gemma
\item \code{taxon.NCBI}: NCBI ID of the taxon
\item \code{taxon.database.name}: Underlying database used in Gemma for the taxon
\item \code{taxon.database.ID}: ID of the underyling database used in Gemma for the taxon
}
}
\description{
Retrieve all datasets
}
\examples{
get_datasets()
get_datasets(taxa = c("mouse", "human"), uris = "http://purl.obolibrary.org/obo/UBERON_0002048")
# filter below is equivalent to the call above
get_datasets(filter = "taxon.commonName in (mouse,human) and allCharacteristics.valueUri = http://purl.obolibrary.org/obo/UBERON_0002048")
get_datasets(query = "lung")
}
\keyword{dataset}
