% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allEndpoints.R
\name{get_dataset_quantitation_types}
\alias{get_dataset_quantitation_types}
\title{Retrieve quantitation types of a dataset}
\usage{
get_dataset_quantitation_types(
  dataset,
  raw = getOption("gemma.raw", FALSE),
  memoised = getOption("gemma.memoised", FALSE),
  file = getOption("gemma.file", NA_character_),
  overwrite = getOption("gemma.overwrite", FALSE)
)
}
\arguments{
\item{dataset}{A numerical dataset identifier or a dataset short name}

\item{raw}{\code{TRUE} to receive results as-is from Gemma, or \code{FALSE} to enable
parsing. Raw results usually contain additional fields and flags that are
omitted in the parsed results.}

\item{memoised}{Whether or not to save to cache for future calls with the
same inputs and use the result saved in cache if a result is already saved.
Doing \code{options(gemma.memoised = TRUE)} will ensure that the cache is always
used. Use \code{\link{forget_gemma_memoised}} to clear the cache.}

\item{file}{The name of a file to save the results to, or \code{NULL} to not write
results to a file. If \code{raw == TRUE}, the output will be the raw endpoint from the
API, likely a JSON or a gzip file. Otherwise, it will be a RDS file.}

\item{overwrite}{Whether or not to overwrite if a file exists at the specified
filename.}
}
\value{
A data.table containing the quantitation types

The fields of the output data.table are:

\itemize{
\item \code{id}: If of the quantitation type. Any raw quantitation type
can be accessed by \code{\link{get_dataset_raw_expression}} function using
this id.
\item \code{name}: Name of the quantitation type
\item \code{description}: Description of the quantitation type
\item \code{type}: Type of the quantitation type. Either raw or processed.
Each dataset will have one processed quantitation type which is the data
returned using \code{\link{get_dataset_processed_expression}}
\item \code{ratio}: Whether or not the quanitation type is a ratio of multiple
quantitation types. Typically TRUE for processed TWOCOLOR quantitation type.
\item \code{preferred}: The preferred raw quantitation type. This version
is used in generation of the processed data within gemma.
\item \code{recomputed}: If TRUE this quantitation type is generated by
recomputing raw data files Gemma had access to.
}
}
\description{
Retrieve quantitation types of a dataset
}
\examples{
get_dataset_quantitation_types("GSE59918")
}
\keyword{dataset}
