% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allEndpoints.R
\name{.get_gene_differential_expression_values_in_taxon}
\alias{.get_gene_differential_expression_values_in_taxon}
\title{Retrieve the differential expression results for a given gene and taxa among datasets matching the provided query and filter}
\usage{
.get_gene_differential_expression_values_in_taxon(
  gene,
  query = NA_character_,
  taxon = NA_character_,
  uris = NA_character_,
  filter = NA_character_,
  threshold = 1,
  raw = getOption("gemma.raw", FALSE),
  memoised = getOption("gemma.memoised", FALSE),
  file = getOption("gemma.file", NA_character_),
  overwrite = getOption("gemma.overwrite", FALSE)
)
}
\arguments{
\item{gene}{An ensembl gene identifier which typically starts with ensg or an ncbi gene identifier or an official gene symbol approved by hgnc}

\item{query}{The search query. Queries can include plain text or ontology
terms They also support conjunctions ("alpha AND beta"), disjunctions ("alpha OR beta")
grouping ("(alpha OR beta) AND gamma"), prefixing ("alpha*"), wildcard characters
("BRCA?") and fuzzy matches ("alpha~").}

\item{taxon}{A numerical taxon identifier or an ncbi taxon identifier or a taxon identifier that matches either its scientific or common name}

\item{uris}{A vector of ontology term URIs. Providing multiple terms will
return results containing any of the terms and their children. These are
appended to the filter and equivalent to filtering for \code{allCharacteristics.valueUri}}

\item{filter}{Filter results by matching expression. Use \code{\link{filter_properties}}
function to get a list of all available parameters. These properties can be
combined using "and" "or" clauses and may contain common operators such as "=", "<" or "in".
(e.g. "taxon.commonName = human", "taxon.commonName in (human,mouse), "id < 1000")}

\item{threshold}{number}

\item{raw}{\code{TRUE} to receive results as-is from Gemma, or \code{FALSE} to enable
parsing. Raw results usually contain additional fields and flags that are
omitted in the parsed results.}

\item{memoised}{Whether or not to save to cache for future calls with the
same inputs and use the result saved in cache if a result is already saved.
Doing \code{options(gemma.memoised = TRUE)} will ensure that the cache is always
used. Use \code{\link{forget_gemma_memoised}} to clear the cache.}

\item{file}{The name of a file to save the results to, or \code{NULL} to not write
results to a file. If \code{raw == TRUE}, the output will be the raw endpoint from the
API, likely a JSON or a gzip file. Otherwise, it will be a RDS file.}

\item{overwrite}{Whether or not to overwrite if a file exists at the specified
filename.}
}
\value{
Varies
}
\description{
Retrieve the differential expression results for a given gene and taxa among datasets matching the provided query and filter
}
\keyword{internal}
