% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotUpSet.R
\name{plotUpSet}
\alias{plotUpSet}
\title{Plot an UpSet Diagram from Genomic or Set Overlap Results}
\usage{
plotUpSet(overlap_object, customSetOrder = NULL, comb_col = "black")
}
\arguments{
\item{overlap_object}{A \code{GenomicOverlapsResult} or \code{SetOverlapsResult} object
returned by \code{\link{computeOverlaps}}.}

\item{customSetOrder}{Optional. A vector specifying the order of sets to
display on the UpSet diagram. The vector should contain either numeric
indices (corresponding to the sets in the overlap object) or character
names (matching the set names). If \code{NULL} (default), sets are displayed
in decreasing order of their size (\code{set_size()}).}

\item{comb_col}{Optional. Color(s) for the combination matrix dots and
connecting lines. Can be a single color, a vector of colors (recycled to
match the number of intersections). Default is "black".}
}
\value{
An UpSet plot object generated by \code{ComplexHeatmap::UpSet}.
}
\description{
This function creates an UpSet plot using the \code{ComplexHeatmap} package to
visualize intersections across multiple sets.
Supports both \code{GenomicOverlapsResult} and \code{SetOverlapsResult} objects.
}
\examples{
# Example with gene sets (built-in dataset)
data(gene_list)
res_sets <- computeOverlaps(gene_list)

# Default order (sets sorted by size)
plotUpSet(res_sets)

# Custom color
plotUpSet(res_sets, comb_col = "darkblue")

# Custom order by names
plotUpSet(res_sets, customSetOrder = c("random_genes_C",
                                       "random_genes_A",
                                       "random_genes_B"))

# Example with genomic regions (built-in dataset)
data(a549_chipseq_peaks)
res_genomic <- computeOverlaps(a549_chipseq_peaks)
plotUpSet(res_genomic)
}
