% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{gene_list}
\alias{gene_list}
\title{Example Gene Lists with Overlaps}
\format{
A named \code{list} of length 3. Each element is a character vector
of gene symbols:
\describe{
\item{random_genes_A}{125 gene symbols.}
\item{random_genes_B}{115 gene symbols.}
\item{random_genes_C}{70 gene symbols.}
}
}
\source{
Generated from \pkg{org.Hs.eg.db} (keys of type \code{SYMBOL}),
using a reproducible random seed.
}
\usage{
gene_list
}
\description{
A synthetic dataset of three gene lists, created from the first 250 human
gene symbols in \pkg{org.Hs.eg.db}.
}
\examples{
data(gene_list)

# Inspect the list
str(gene_list)

# Compute overlaps and plot
ov <- computeOverlaps(gene_list)
plotVenn(ov)
}
\keyword{datasets}
