% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_mae_se_assay_to_dt.R
\name{convert_se_assay_to_dt}
\alias{convert_se_assay_to_dt}
\title{Convert a SummarizedExperiment assay to a long data.table}
\usage{
convert_se_assay_to_dt(
  se,
  assay_name,
  include_metadata = TRUE,
  retain_nested_rownames = FALSE,
  wide_structure = FALSE,
  unify_metadata = FALSE,
  drop_masked = TRUE
)
}
\arguments{
\item{se}{A \linkS4class{SummarizedExperiment} object holding raw and/or processed dose-response data in its assays.}

\item{assay_name}{String of name of the assay to transform within the \code{se}.}

\item{include_metadata}{Boolean indicating whether or not to include \code{rowData(se)}
and \code{colData(se)} in the returned data.table.
Defaults to \code{TRUE}.}

\item{retain_nested_rownames}{Boolean indicating whether or not to retain the rownames
nested within a \code{BumpyMatrix} assay.
Defaults to \code{FALSE}.
If the \code{assay_name} is not of the \code{BumpyMatrix} class, this argument's value is ignored.
If \code{TRUE}, the resulting column in the data.table will be named as \code{"<assay_name>_rownames"}.}

\item{wide_structure}{Boolean indicating whether or not to transform data.table into wide format.
\code{wide_structure = TRUE} requires \code{retain_nested_rownames = TRUE}.}

\item{unify_metadata}{Boolean indicating whether to unify DrugName and CellLineName in cases where DrugNames
and CellLineNames are shared by more than one Gnumber and/or clid within the experiment.}

\item{drop_masked}{Boolean indicating whether to drop masked values; TRUE by default.}
}
\value{
data.table representation of the data in \code{assay_name}.
}
\description{
Convert an assay within a \linkS4class{SummarizedExperiment} object to a long data.table.
}
\details{
NOTE: to extract information about 'Control' data, simply call the
function with the name of the assay holding data on controls.
To extract the reference data in to same format as 'Averaged' use \code{convert_se_ref_assay_to_dt}.
}
\examples{
mae <- get_synthetic_data("finalMAE_small")
se <- mae[[1]]
convert_se_assay_to_dt(se, "Metrics")

}
\seealso{
flatten
}
\keyword{convert}
