% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combinations-helpers.R
\name{map_ids_to_fits}
\alias{map_ids_to_fits}
\title{Get predicted values for a given fit and input.}
\usage{
map_ids_to_fits(pred, match_col, fittings, fitting_id_col)
}
\arguments{
\item{pred}{numeric vector for which you want predictions.}

\item{match_col}{vector to match on \code{fittings} to get the correct fit.}

\item{fittings}{data.table of fit metrics.}

\item{fitting_id_col}{string of the column name in \code{fittings} that
should be used to match with \code{match_col} .}
}
\value{
Numeric vector of predicted values given \code{pred} inputs
and \code{fittings} values.
}
\description{
Map fittings to identifiers and compute the predicted values
for corresponding fits.
}
\examples{
pred <- c(1, 5, 5)
match_col <- c(1, 1, 2)
fitting_id_col <- "match_on_me"

fit1 <- data.table::data.table(h = 2.09, x_inf = 0.68, x_0 = 1, ec50 = 0.003)
fit2 <- data.table::data.table(h = 0.906, x_inf = 0.46, x_0 = 1, ec50 = 0.001)
fittings <- do.call(rbind, list(fit1, fit2))
fittings[[fitting_id_col]] <- c(1, 2)

map_ids_to_fits(pred, match_col, fittings, fitting_id_col)

}
\keyword{map_df}
