% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_annotation.R
\name{annotate_mae_with_drug}
\alias{annotate_mae_with_drug}
\title{annotate_mae_with_drug}
\usage{
annotate_mae_with_drug(mae, drug_annotation, fill = "unknown")
}
\arguments{
\item{mae}{MultiAssayExperiment object containing dose-response data}

\item{drug_annotation}{data.table with drug annotations}

\item{fill}{string indicating how unknown drugs should be filled in the DB}
}
\value{
MultiAssayExperiment object with annotated drugs
}
\description{
Annotate MultiAssayExperiment object with drug annotations
}
\examples{
mae <- MultiAssayExperiment::MultiAssayExperiment(
  experiments = list(exp1 = SummarizedExperiment::SummarizedExperiment(
    rowData = data.table::data.table(Gnumber = c("D1", "D2", "D3"))
  ))
)
drug_annotation <- get_drug_annotation(data.table::as.data.table(
  SummarizedExperiment::rowData(
    MultiAssayExperiment::experiments(mae)[[1]])))
annotated_mae <- annotate_mae_with_drug(mae, drug_annotation)
}
\keyword{annotation}
