% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stitchRanges.R
\name{stitchRanges}
\alias{stitchRanges}
\title{Stitch Ranges within a given distance}
\usage{
stitchRanges(x, exclude, maxgap = 12500L, ignore.strand = TRUE)
}
\arguments{
\item{x}{Ranges to be stitched together}

\item{exclude}{Ranges to exclude}

\item{maxgap}{The maximum distance between ranges to be stitched}

\item{ignore.strand}{logical}
}
\value{
A GRanges object
}
\description{
Stitch together ranges within a given distance, using excluded ranges as
barriers that cannot be crossed
}
\details{
Stitches together ranges within a given distance, using any ranges provided
for exclusion as barriers between stitched ranges. This may be particularly
useful if wanting to stitch enhancers whilst excluding promoters.

All inputs and outputs are Genomic Ranges objects
}
\examples{
x <- GRanges(c("chr1:1-10", "chr1:101-110", "chr1:201-210", "chr2:1-10"))
y <- GRanges("chr1:200:+")
stitchRanges(x, exclude = y, maxgap = 100)

}
