% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reduceMC.R
\name{reduceMC}
\alias{reduceMC}
\title{Reduce ranges retaining mcols}
\usage{
reduceMC(x, ignore.strand = FALSE, simplify = TRUE, ...)
}
\arguments{
\item{x}{A GenomicRanges object}

\item{ignore.strand}{If set to TRUE, then the strand of x and y is set to
"*" prior to any computation.}

\item{simplify}{logical(1). Attempt to simplify returned columns where
possible}

\item{...}{Passed to \link[GenomicRanges]{reduce}}
}
\value{
A GRanges object
}
\description{
Reduce ranges retaining mcols
}
\details{
This function extends \link[GenomicRanges]{reduce} so that \strong{all} \code{mcols}
are returned in the output.
Where the reduced ranges map to multiple ranges in the original range,
\code{mcols} will be returned as \code{CompressedList} columns.

If \code{simplify = TRUE} columns will be returned as vectors where possible.
}
\examples{
x <- GRanges(c("chr1:1-10:+", "chr1:6-12:-"))
x$id <- c("range1", "range2")
reduceMC(x)
reduceMC(x, ignore.strand = TRUE)

}
