% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mergeByCol.R
\name{mergeByCol}
\alias{mergeByCol}
\alias{mergeByCol,GenomicRanges-method}
\alias{mergeByCol,RangedSummarizedExperiment-method}
\title{Merge sliding windows using a specified column}
\usage{
mergeByCol(x, ...)

\S4method{mergeByCol}{GenomicRanges}(
  x,
  df = NULL,
  col,
  by = c("max", "median", "mean", "min"),
  logfc = "logFC",
  pval = "P",
  inc_cols,
  p_adj_method = "fdr",
  merge_within = 1L,
  ignore_strand = TRUE,
  min_win = 1,
  ...
)

\S4method{mergeByCol}{RangedSummarizedExperiment}(
  x,
  df = NULL,
  col,
  by = c("max", "median", "mean", "min"),
  logfc = "logFC",
  pval = "P",
  inc_cols,
  p_adj_method = "fdr",
  merge_within = 1L,
  ignore_strand = FALSE,
  ...
)
}
\arguments{
\item{x}{A GenomicRanges or SummarizedExperiment object}

\item{...}{Not used}

\item{df}{A data.frame-like object containing the columns of interest. If
not provided, any columns in the mcols() slot will be used.}

\item{col}{The column to select as representative of the merged ranges}

\item{by}{The method for selecting representative values}

\item{logfc}{Column containing logFC values}

\item{pval}{Column containing p-values}

\item{inc_cols}{Any additional columns to return. Output will always include
columns specified in the arguments \code{col}, \code{logfc} and \code{pval}. Note that
values from any additional columns will correspond to the selected range
returned in keyval_range}

\item{p_adj_method}{Any of \link{p.adjust.methods}}

\item{merge_within}{Merge any ranges within this distance}

\item{ignore_strand}{Passed internally to \link[GenomicRanges]{reduce} and
\link[GenomicRanges]{findOverlaps}}

\item{min_win}{Only keep merged windows derived from at least this number}
}
\value{
A Genomic Ranges object
}
\description{
Merge sliding windows using a specified column
}
\details{
This merges sliding windows using the values in a given column to select
representative values for the subsequent merged windows.
Values can be chosen from the specified column using any of \code{min()},
\code{max()}, \code{mean()} or \code{median()}, although \code{max()} is strongly recommended
when specifying values like logCPM.
Once a representative range is selected using the specified column, values
from columns specified using \code{inc_cols} are also returned.
In addition to these columns, the range from the representative window is
returned in the mcols element as a GRanges object in the column
\code{keyval_range}.

Merging windows using either the logFC or p-value columns is not implemented.

If adjusted p-values are requested an additional column names the same as
the initial p-value, but tagged with the adjustment method, will be added.
In addition, using the p-value from the selected window, the number of
windows with lower p-values are counted by direction and returned in the
final object.
The selected window will always be counted as up/down regardless of
significance as the p-value for this column is taken as the threshold.
This is a not dissimilar approach to \link[csaw]{cluster-direction}.

If called on a SummarizedExperiment object, the function will be applied to
the \code{rowRanges} element.
}
\examples{
x <- GRanges(c("chr1:1-10", "chr1:6-15", "chr1:51-60"))
set.seed(1001)
df <- DataFrame(logFC = rnorm(3), logCPM = rnorm(3,8), p = rexp(3, 10))
mergeByCol(x, df, col = "logCPM", pval = "p")
mcols(x) <- df
x
mergeByCol(x, col = "logCPM", pval = "p")

}
