% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/getProfileData.R
\name{getProfileData}
\alias{getProfileData}
\alias{getProfileData,BigWigFile,GenomicRanges-method}
\alias{getProfileData,BigWigFileList,GenomicRanges-method}
\alias{getProfileData,character,GenomicRanges-method}
\title{Get Profile Data surrounding specified ranges}
\usage{
getProfileData(x, gr, ...)

\S4method{getProfileData}{BigWigFile,GenomicRanges}(
  x,
  gr,
  upstream = 2500,
  downstream = upstream,
  bins = 100,
  mean_mode = "w0",
  log = TRUE,
  offset = 1,
  n_max = Inf,
  ...
)

\S4method{getProfileData}{BigWigFileList,GenomicRanges}(
  x,
  gr,
  upstream = 2500,
  downstream = upstream,
  bins = 100,
  mean_mode = "w0",
  log = TRUE,
  offset = 1,
  BPPARAM = SerialParam(),
  ...
)

\S4method{getProfileData}{character,GenomicRanges}(
  x,
  gr,
  upstream = 2500,
  downstream = upstream,
  bins = 100,
  mean_mode = "w0",
  log = TRUE,
  offset = 1,
  ...
)
}
\arguments{
\item{x}{A BigWigFile or BigWiFileList}

\item{gr}{A GRanges object}

\item{...}{Passed to \link[EnrichedHeatmap]{normalizeToMatrix}}

\item{upstream}{The distance to extend upstream from the centre of each
range within \code{gr}}

\item{downstream}{The distance to extend downstream from the centre of each
range within \code{gr}}

\item{bins}{The total number of bins to break the extended ranges into}

\item{mean_mode}{The method used for calculating the score for each bin.
See \link[EnrichedHeatmap]{normalizeToMatrix} for details}

\item{log}{logical(1) Should the returned values be log2-transformed}

\item{offset}{Value added to data if log-transforming. Ignored otherwise}

\item{n_max}{Upper limit on the number of ranges to return profile data for.
By default, no limit will be applied .}

\item{BPPARAM}{Passed internally to \link[BiocParallel]{bplapply}}
}
\value{
GRanges or GrangesList with column profile_data, as described above
}
\description{
Get coverage Profile Data surrounding specified ranges
}
\details{
This will take all provided ranges and set as identical width ranges,
extending by the specified amount both up and downstream of the centre of the
provided ranges. By default, the ranges extensions are symmetrical and only
the upstream range needs to be specified, however this parameterisation
allows for non-symmetrical ranges to be generated.

These uniform width ranges will then be used to extract the value contained
in the score field from one or more BigWigFiles. Uniform width ranges are
then broken into bins of equal width and the average score found within each
bin.

The binned profiles are returned as a DataFrameList called \code{profile_data} as
a column within the resized GRanges object.
Column names in each DataFrame are \code{score}, \code{position} and \code{bp}.

If passing a BigWigFileList, profiles will be obtained in series by
default. To run in parallel pass a \link[BiocParallel]{MulticoreParam} object
to the \code{BPPARAM} argument.
}
\examples{
bw <- system.file("tests", "test.bw", package = "rtracklayer")
gr <- GRanges("chr2:1000")
pd <- getProfileData(bw, gr, upstream = 500, bins = 10)
pd
pd$profile_data

}
