% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exportToGtf.R
\name{exportToGtf}
\alias{exportToGtf}
\title{Export GRangesList to GTF}
\usage{
exportToGtf(grl, filepath)
}
\arguments{
\item{grl}{\code{GRangesList} object, typically generated by
\code{getFeatureRanges}}

\item{filepath}{Path to output GTF file}
}
\value{
Does not return anything, generates a GTF file
}
\description{
Export the features in a GRangesList generated by \code{getFeatureRanges}
to a GTF file. The function will represent each row of each of the
entries as an "exon", each individual entry as a "transcript", and
aggregate all features belonging to the same gene as a "gene" entry in
the GTF file.
}
\examples{
  ## Get feature ranges
  grl <- getFeatureRanges(
    gtf = system.file("extdata/small_example.gtf", package = "eisaR"),
    featureType = c("spliced", "intron"),
    intronType = "separate",
    flankLength = 5L,
    joinOverlappingIntrons = FALSE,
    verbose = TRUE
  )
  
  ## Export GTF
  exportToGtf(grl = grl, filepath = file.path(tempdir(), "exported.gtf"))

}
\author{
Charlotte Soneson
}
