% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gene-getters.R
\name{isGene}
\alias{isGene}
\title{Tests if input is the name of a gene in a target object.}
\usage{
isGene(
  test,
  object,
  assay = .default_assay(object),
  return.values = FALSE,
  swap.rownames = NULL
)
}
\arguments{
\item{test}{String or vector of strings, the "potential.gene.name"(s) to check for.}

\item{object}{A Seurat, SingleCellExperiment, or SummarizedExperiment object.}

\item{assay}{single string or integer that sets which set of seq data inside the object to check.}

\item{return.values}{Logical which sets whether the function returns a logical \code{TRUE}/\code{FALSE} versus the \code{TRUE} \code{test} values . Default = \code{FALSE}
REQUIRED, unless '\code{DEFAULT <- "object"}' has been run.}

\item{swap.rownames}{optionally named string or string vector.
For SummarizedExperiment or SingleCellExperiment objects, its value(s) specifies the column name of rowData(object) to be used to identify features instead of rownames(object).
When targeting multiple modalities (alternative experiments), names can be used to specify which level / alternative experiment (use 'main' for the top-level) individual values should be used for.
See \code{\link{GeneTargeting}} for more specifics and examples.}
}
\value{
Returns a logical vector indicating whether each instance in \code{test} is a rowname within the requested \code{assay} of the \code{object}.
Alternatively, returns the values of \code{test} that were indeed rownames if \code{return.values = TRUE}.
}
\description{
Tests if input is the name of a gene in a target object.
}
\examples{
example(importDittoBulk, echo = FALSE)

# To see the first 10 genes of an object of a particular assay
getGenes(myRNA, assay = "counts")[1:10]

# To see all genes of an object for the default assay that dittoSeq would use
# leave out the assay input (again, remove `head()`)
head(getGenes(myRNA))

# To test if something is a gene in an object:
isGene("gene1", object = myRNA) # TRUE
isGene("CD12345", myRNA) # FALSE

# To test if many things are genes of an object
isGene(c("gene1", "gene2", "not-a-gene", "CD12345"), myRNA)

# 'return.values' input is especially useful in these cases.
isGene(c("gene1", "gene2", "not-a-gene", "CD12345"), myRNA,
    return.values = TRUE)

}
\seealso{
\code{\link{getGenes}} for returning all genes in an \code{object}

\code{\link{gene}} for obtaining the expression data of genes
}
\author{
Daniel Bunis
}
