% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_taxa.R
\name{step_filter_taxa}
\alias{step_filter_taxa}
\alias{step_filter_taxa,Recipe-method}
\title{Filter taxa based on across-sample OTU abundance criteria}
\usage{
step_filter_taxa(rec, .f, id = rand_id("filter_taxa"))

\S4method{step_filter_taxa}{Recipe}(rec, .f, id = rand_id("filter_taxa"))
}
\arguments{
\item{rec}{A Recipe object. The step will be added to the sequence of
operations for this Recipe.}

\item{.f}{A function or list of functions that take a vector of abundance
values and return a logical. Some canned useful function types are included
in the genefilter-package.}

\item{id}{A character string that is unique to this step to identify it.}
}
\value{
An object of class \code{Recipe}
}
\description{
This function is directly analogous to the genefilter function for microarray
filtering, but is used for filtering OTUs from phyloseq objects. It applies
an arbitrary set of functions — as a function list, for instance, created by
filterfun — as across-sample criteria, one OTU at a time. It takes as input a
phyloseq object, and returns a logical vector indicating whether or not each
OTU passed the criteria. Alternatively, if the "prune" option is set to
FALSE, it returns the already-trimmed version of the phyloseq object.
}
\examples{
data(metaHIV_phy)

## Init Recipe
rec <- recipe(metaHIV_phy, "RiskGroup2", "Phylum")
rec

## Define filter taxa step with default parameters
rec <- 
  step_filter_taxa(rec, .f = "function(x) sum(x > 0) >= (0.03 * length(x))")
  
rec
}
\seealso{
Other filter phy steps: 
\code{\link{step_filter_by_abundance}()},
\code{\link{step_filter_by_prevalence}()},
\code{\link{step_filter_by_rarity}()},
\code{\link{step_filter_by_variance}()}
}
\concept{filter phy steps}
