% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findConsensusPeakRegionsIntern.R
\encoding{UTF-8}
\name{findConsensusPeakRegionsValidation}
\alias{findConsensusPeakRegionsValidation}
\title{Parameter validation for the \code{\link{findConsensusPeakRegions}}
function}
\usage{
findConsensusPeakRegionsValidation(
  narrowPeaks,
  peaks,
  chrList,
  extendingSize,
  expandToFitPeakRegion,
  shrinkToFitPeakRegion,
  minNbrExp,
  nbrThreads
)
}
\arguments{
\item{narrowPeaks}{a \code{GRanges} representing called peaks of signal
for all experiments.}

\item{peaks}{a \code{GRanges} representing peaks for all experiments.}

\item{chrList}{a \code{Seqinfo} containing the name and the length of the
chromosomes to analyze which indicate that all chromosomes must
be analyzed.}

\item{extendingSize}{a \code{numeric} value indicating the size of padding
at each side of the peaks median position to create the consensus
region. The minimum size of the consensus region will be equal to
twice the value of the \code{extendingSize} parameter. The size of
the \code{extendingSize} must be a positive integer. Default = 250.}

\item{expandToFitPeakRegion}{a \code{logical} indicating if the region set
by the \code{extendingSize} parameter is extended to include all
region of the peak closest to the peaks median position for each
experiment.}

\item{shrinkToFitPeakRegion}{a \code{logical} indicating if the region size,
which is set by the \code{extendingSize} parameter is shrinked to
fit the narrow peak regions of the peaks when all those regions
are smaller than the consensus region.}

\item{minNbrExp}{a \code{numeric} indicating the minimum number of BED files
in which a peak must be present for a region to be retained. The numeric
must be a positive value inferior or equal to the number of files
present in the \code{narrowPeakFiles} parameter. Default = 1.}

\item{nbrThreads}{a \code{numeric} indicating the number of threads to use
in parallel.}
}
\value{
\code{0} indicating that all parameters validations have been
successful.
}
\description{
Validation of all parameters needed by the public
\code{\link{findConsensusPeakRegions}} function.
}
\examples{

## Loading datasets
data(A549_FOSL2_01_NarrowPeaks_partial)
data(A549_FOXA1_01_NarrowPeaks_partial)
data(A549_FOSL2_01_Peaks_partial)
data(A549_FOXA1_01_Peaks_partial)

## Assigning experiment name to each row of the dataset.
## NarrowPeak and Peak datasets from the same experiment must
## have identical names.
names(A549_FOXA1_01_Peaks_partial) <- rep("FOXA1_01",
                        length(A549_FOXA1_01_Peaks_partial))
names(A549_FOXA1_01_NarrowPeaks_partial) <- rep("FOXA1_01",
                        length(A549_FOXA1_01_NarrowPeaks_partial))
names(A549_FOSL2_01_Peaks_partial) <- rep("FOSL2_01",
                        length(A549_FOSL2_01_Peaks_partial))
names(A549_FOSL2_01_NarrowPeaks_partial) <- rep("FOSL2_01",
                        length(A549_FOSL2_01_NarrowPeaks_partial))

chrList <- Seqinfo("chr10", 135534747, NA)

consensusSeekeR:::findConsensusPeakRegionsValidation(
    narrowPeaks = c(A549_FOXA1_01_NarrowPeaks_partial,
            A549_FOSL2_01_NarrowPeaks_partial),
    peaks = c(A549_FOXA1_01_Peaks_partial,
            A549_FOSL2_01_Peaks_partial),
    chrList = chrList,
    extendingSize = 110,
    expandToFitPeakRegion = FALSE,
    shrinkToFitPeakRegion = TRUE,
    minNbrExp = 2,
    nbrThreads = 1)

}
\author{
Astrid Deschênes
}
\keyword{internal}
