% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/consensusSeekeR.R
\docType{data}
\name{A549_FOXA1_01_Peaks_partial}
\alias{A549_FOXA1_01_Peaks_partial}
\title{Sites with the greatest evidence of transcription factor binding
for the FOXA1 transcription factor (for demonstration purpose)}
\format{
A \code{GRanges} containing one entry per site
. Each row of \code{GRanges} has a name which represent the name of
the experiment.
}
\source{
The Encyclopedia of DNA Elements (ENCODE) (DCC accession:
ENCFF000NAH)
}
\usage{
data(A549_FOXA1_01_Peaks_partial)
}
\description{
Sites representing the greatest evidence of enrichment for
the FOXA1 transcription factor (DCC accession: ENCFF000NAH)
for regions chr1:249120200-249250621 and chr10:1-370100
from the Encyclopedia of DNA Elements (ENCODE) data (Dunham I et al. 2012).
}
\examples{

## Loading datasets
data(A549_FOSL2_01_NarrowPeaks_partial)
data(A549_FOSL2_01_Peaks_partial)
data(A549_FOXA1_01_NarrowPeaks_partial)
data(A549_FOXA1_01_Peaks_partial)

## Assigning experiment name to each row of the dataset.
## NarrowPeak and Peak datasets from the same experiment must
## have identical names.
names(A549_FOXA1_01_Peaks_partial) <- rep("FOXA1_01",
        length(A549_FOXA1_01_Peaks_partial))
names(A549_FOXA1_01_NarrowPeaks_partial) <- rep("FOXA1_01",
        length(A549_FOXA1_01_NarrowPeaks_partial))
names(A549_FOSL2_01_Peaks_partial) <-rep("FOSL2_01",
        length(A549_FOSL2_01_Peaks_partial))
names(A549_FOSL2_01_NarrowPeaks_partial) <- rep("FOSL2_01",
        length(A549_FOSL2_01_NarrowPeaks_partial))

## Calculating consensus regions for both chromosomes 1 and 10
## with a default region size of 100 bp (2 * extendingSize)
## which is extended to include all genomic regions for the closest
## peak to the median position of all peaks included in the region (for each
## experiment).
## A peak from both experiments must be present in a region to
## be retained as a consensus region.
chrList <- Seqinfo(c("chr1", "chr10"), c(249250621, 135534747), NA)
findConsensusPeakRegions(
    narrowPeaks = c(A549_FOXA1_01_NarrowPeaks_partial,
                            A549_FOSL2_01_NarrowPeaks_partial),
    peaks = c(A549_FOXA1_01_Peaks_partial,
                            A549_FOSL2_01_Peaks_partial),
    chrInfo = chrList,
    extendingSize = 50,
    expandToFitPeakRegion = TRUE,
    shrinkToFitPeakRegion = TRUE,
    minNbrExp = 2,
    nbrThreads = 1)

}
\references{
\itemize{
\item Dunham I, Kundaje A, Aldred SF, et al. An integrated encyclopedia
of DNA elements in the human genome. Nature. 2012 Sep 6;489(7414):57-74.
}
}
\seealso{
\itemize{
    \item{\code{\link{A549_FOXA1_01_NarrowPeaks_partial}} the associate
genomic regions dataset.}
    \item{\code{\link{findConsensusPeakRegions}} for extracting regions
sharing the same features in more than one experiment.}
}
}
\keyword{datasets}
