% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contrasting_functions.r
\name{contrast_the_group_to_the_rest}
\alias{contrast_the_group_to_the_rest}
\title{contrast_the_group_to_the_rest}
\usage{
contrast_the_group_to_the_rest(dataset_se, the_group,
  pvalue_threshold = 0.01, n.group = Inf, n.other = n.group * 5)
}
\arguments{
\item{dataset_se}{Datast summarisedExperiment object.}

\item{the_group}{group to test}

\item{pvalue_threshold}{Default = 0.01}

\item{n.group}{How many cells to keep for each group in groupwise 
comparisons. Default = Inf}

\item{n.other}{How many cells to keep from everything not in the group.
Default = \bold{n.group} * 5}
}
\value{
A tibble, the within-experiment de_table (differential expression
table), for the group specified.
}
\description{
Internal function to calculate differential expression within an experiment
between a specified group and cells not in that group.
}
\details{
This function should only be called by 
\code{contrast_each_group_to_the_rest}
(which can be passed a single group name if desired). Else 'pofgenes' will
not be defined.

MAST is supplied with log2(counts + 1.1), and zlm called with model
'~ TvsR + pofgenes' . The p-values reported are from the hurdle model. FDR 
is with default fdr/BH method.
}
\seealso{
\code{\link{contrast_each_group_to_the_rest}}
}
