% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_perturbation.R
\name{calc_perturbation}
\alias{calc_perturbation}
\title{Calculates average expression changes of all nodes except
trigger and finds the perturbed node count for a given node.}
\usage{
calc_perturbation(input_graph, node_name, how = 1, cycle = 1, limit = 0)
}
\arguments{
\item{input_graph}{the graph object that was processed with
priming graph in previous step.}

\item{node_name}{The node that is trigger for simulation.}

\item{how}{The change of count of the given node in terms of fold change.}

\item{cycle}{The iteration of simulation.}

\item{limit}{The minimum fold change which can be taken into
account for perturbation calculation on all nodes in terms of percentage.}
}
\value{
a tibble with two columns, the perturbation
efficiency and number of perturbed nodes.
}
\description{
Calculates average expression changes of all nodes except
trigger and finds the perturbed node count for a given node.
}
\details{
calc_perturbation calculates mean expression changes
of elements except trigger after the change in the network
in terms of percentage. It also calculates the number of nodes
that have expression changes after the change occur in the network.
The function determines the perturbation efficiency and number
of perturbed nodes after given change with how, cycle and
limit parameter.
}
\examples{

data('minsamp')

minsamp\%>\%
   priming_graph(competing_count = Competing_expression,
       miRNA_count = miRNA_expression)\%>\%
   calc_perturbation('Gene6', how= 3, cycle = 4)

 minsamp\%>\%
   priming_graph(competing_count = Competing_expression, miRNA_count = miRNA_expression,
       aff_factor = c(energy,seed_type), deg_factor = region)\%>\%
   calc_perturbation('Gene6',3, cycle = 4)


}
