% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_framework.R
\name{createBiodbTestInstance}
\alias{createBiodbTestInstance}
\title{Creating a BiodbMain instance for tests.}
\usage{
createBiodbTestInstance(ack = FALSE)
}
\arguments{
\item{ack}{If set to TRUE, an instance of BiodbTestMsgAck will be attached to
the BiodbMain instance.}
}
\value{
The created BiodbMain instance.
}
\description{
Creates a BiodbMain instance with options specially adapted for tests.
You can request the logging of all messages into a log file.
It is also possible to ask for the creation of a BiodbTestMsgAck observer,
which will receive all messages and emit a testthat test for each message.
This will allow the testthat output to not stall a long time while, for
example, downloading or extracting a database.
Do not forget to call \code{terminate()} on your instance at the end of your
tests.
}
\examples{
# Instantiate a BiodbMain instance for testing
biodb <- biodb::createBiodbTestInstance()

# Terminate the instance
biodb$terminate()

}
