% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_annotations.R
\name{build_ah_annots}
\alias{build_ah_annots}
\title{A helper function to build arbitrary annotatinos from AnnotationHub}
\usage{
build_ah_annots(genome, ah_codes, annotation_class)
}
\arguments{
\item{genome}{The genome assembly.}

\item{ah_codes}{A named character vector giving the AnnotationHub accession number (e.g. AH23256), and whose name describes what the annotation is (e.g. Gm12878_H3K4me3).}

\item{annotation_class}{A string to name the group of annotations in \code{ah_codes}}
}
\value{
A \code{GRanges} object stored in \code{annotatr_cache}. To view an annotation built with this function, do \code{annotatr_cache$get(name)}. To add these annotations to a set of annotations, include \code{'[genome]_[annotation_class]_[name]'} in the call to \code{build_annotations()}. See example below.
}
\description{
A helper function to build arbitrary annotatinos from AnnotationHub
}
\examples{

# Create a named vector for the AnnotationHub accession codes with desired names
h3k4me3_code = c('Gm12878' = 'AH23256')
# Fetch ah_codes from AnnotationHub and create annotations annotatr understands
build_ah_annots(genome = 'hg19', ah_codes = h3k4me3_code, annotation_class = 'H3K4me3')
# The annotations as they appear in annotatr_cache
annot_name = c('hg19_H3K4me3_Gm12878')
# Build the annotations right before annotating any regions
annotations = build_annotations(genome = 'hg19', annotations = annot_name)

}
