% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anglemania.R, R/prepare_anglemania.R
\name{anglemania}
\alias{anglemania}
\alias{check_params}
\alias{add_unique_batch_key}
\alias{get_intersect_genes}
\title{anglemania}
\usage{
anglemania(
  sce,
  batch_key,
  dataset_key = NA_character_,
  max_n_genes = 2000,
  min_cells_per_gene = 1,
  min_samples_per_gene = 2,
  allow_missing_features = FALSE,
  method = "cosine",
  permute_row_or_column = "column",
  permutation_function = "sample",
  prefilter_threshold = 0.5,
  normalization_method = "divide_by_total_counts",
  verbose = TRUE
)

check_params(
  sce,
  batch_key,
  dataset_key,
  max_n_genes,
  method,
  min_cells_per_gene,
  min_samples_per_gene,
  allow_missing_features,
  permute_row_or_column,
  permutation_function,
  prefilter_threshold,
  normalization_method,
  verbose
)

add_unique_batch_key(sce, dataset_key = NA_character_, batch_key)

get_intersect_genes(
  matrix_list,
  allow_missing_features = FALSE,
  min_samples_per_gene = 1,
  verbose = TRUE
)
}
\arguments{
\item{sce}{A \code{SingleCellExperiment} object.}

\item{batch_key}{A character string specifying the column name in the
metadata that identifies the batch.}

\item{dataset_key}{A character string specifying the column name in the
metadata that identifies the dataset. If \code{NA}, only the
\code{batch_key} is used.}

\item{max_n_genes}{Integer specifying the maximum number of genes to select.}

\item{min_cells_per_gene}{Integer specifying the minimum number of cells per
gene. Default is \code{1}.}

\item{min_samples_per_gene}{Integer indicating the minimum
number of samples per gene.}

\item{allow_missing_features}{Logical indicating whether
to allow missing features.}

\item{method}{Character string specifying the method to use for calculating
the relationship between gene pairs. Default is \code{"cosine"}.
Other options include \code{"spearman"}}

\item{permute_row_or_column}{Character "row" or "column", whether
permutations
should be executed row-wise or column wise. Default is \code{"column"}}

\item{permutation_function}{Character "sample" or "permute_nonzero". If
sample,then sample is used for constructing background distributions. If
permute_nonzero, then only non-zero values are permuted. Default is
\code{"sample"}}

\item{prefilter_threshold}{Numeric value specifying the threshold
prefiltering
genes. Speeds up gene selection.}

\item{normalization_method}{Character "divide_by_total_counts" or
"scale_by_total_counts". Default is \code{"divide_by_total_counts"}}

\item{verbose}{Logical indicating whether to print messages.}

\item{matrix_list}{A list of \code{bigstatsr::FBM} objects.}
}
\value{
An updated \code{SingleCellExperiment} object with computed
statistics and selected genes.
The results are stored in the metadata of the \code{SingleCellExperiment}
object.

A list of validated parameters

A \code{SingleCellExperiment} object with an additional metadata
column containing the unique batch key.

A character vector of intersected genes.
}
\description{
\code{anglemania} computes critical angles between genes across all samples
provided in an
\link[SingleCellExperiment:SingleCellExperiment-class]{SingleCellExperiment}
object. It calculates angles, transforms them to z-scores, computes
statistical measures, and selects the top genes based on mean and standard
deviation of z-scores.
These genes are biologically informative and invariant to batch effects.

This function adds a unique batch identifier to the metadata of a
\code{SingleCellExperiment} object by combining specified dataset and batch
keys. This is useful for distinguishing samples during integration or
analysis.
}
\details{
This function performs the following steps:
\enumerate{
\item Computes angles between genes for each batch in the
\code{SingleCellExperiment} using the specified \code{method}, via
\code{\link{factorise}}.
\item Transforms the angles to z-scores.
\item Computes statistical measures (mean z-score, signal-to-noise ratio)
across batches using \code{\link{get_list_stats}}.
\item Selects the top n genes based on mean and standard deviation of
z-scores using \code{\link{select_genes}}.
}

The computed statistics and selected genes are added to the
\code{SingleCellExperiment} object, which is returned.
}
\section{Functions}{
\itemize{
\item \code{check_params()}: Check Parameters provided to the anglemania function

\item \code{add_unique_batch_key()}: Temporarily add a unique batch key to the dataset

\item \code{get_intersect_genes()}: Extract the intersected genes from a
list of matrices (count matrices from different batches/datasets).
It also allows for missing features in individual matrices, so
that a feature does not have to be present in every single batch.

}}
\examples{
# Set seed (optional)
set.seed(1)
sce <- sce_example()
sce <- anglemania(
  sce,
  batch_key = "batch",
  method = "cosine"
)

# Access the selected genes
selected_genes <- get_anglemania_genes(sce)
selected_genes[1:10]
sce <- sce_example()
params <- check_params(
  sce,
  batch_key = "batch",
  dataset_key = "dataset",
  max_n_genes = 2000,
  method = "cosine",
  min_cells_per_gene = 1,
  min_samples_per_gene = 2,
  allow_missing_features = FALSE,
  permute_row_or_column = "column",
  permutation_function = "sample",
  prefilter_threshold = 0.5,
  normalization_method = "divide_by_total_counts",
  verbose = TRUE
)
sce <- sce_example()
head(SummarizedExperiment::colData(sce))
sce <- add_unique_batch_key(
    sce,
    batch_key = "batch",
    dataset_key = "dataset"
)
head(SummarizedExperiment::colData(sce))
library(SingleCellExperiment)
sce <- sce_example()
barcodes_by_batch <- split(colnames(sce), colData(sce)$batch)
matrix_list <- lapply(barcodes_by_batch, function(barcodes) {
    SingleCellExperiment::counts(sce)[, barcodes]
})
intersect_genes <- get_intersect_genes(matrix_list)
head(intersect_genes)
}
\seealso{
\code{\link{get_list_stats}},
\code{\link{select_genes}},
\code{\link{factorise}},
\code{\link[bigstatsr]{big_apply}},
\url{https://arxiv.org/abs/1306.0256}
}
