% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{ec2ko}
\alias{ec2ko}
\alias{ec2cpd}
\alias{kegg_link}
\title{Use linking data from the KEGG database.}
\format{
\code{ec2ko}: a \code{data.frame} of two columns, named \code{"ec"}
and \code{"ko"}. The IDs refer to KEGG orthologues. Enzyme commission numbers,
ecs, typically describe reactions captured by them.

\code{ec2cpd}: a \code{data.frame} of two columns, named \code{"ec"} and \code{"cpd"}.
The IDs refer to compounds in the KEGG database. Enzyme commission
numbers, ecs, typically describe reactions either producing or requiring
them.
}
\source{
\code{ec2ko}: Adapted from \url{https://www.genome.jp/kegg/}, using
\code{KEGGREST}. Script to generate available in example.

\code{ec2cpd}: Adapted from \url{https://www.genome.jp/kegg/} using
\code{KEGGREST}. Script to generate available in example.
}
\usage{
data("ec2ko", package = "anansi")

data("ec2cpd", package = "anansi")

kegg_link()
}
\value{
\code{kegg_link()} returns a list containing the two aforementioned
data.frames, \code{ec2cpd} and \code{ec2ko}.
}
\description{
\code{kegg_link()} is a convenience function to return a list containing two
\code{data.frame}s; \code{ec2cpd} and \code{ec2ko}. This will be their most likely use.
\code{ec2cpd} and \code{ec2ko} are two \code{data.frame}s, used to link ko, ecs and cpd
identifiers in the KEGG database.
}
\examples{
kegg_link()

# Generate ec2ko and ec2cpd:
# Don't download during tests. set to `TRUE` to download.
dry_run <- TRUE

if (!dry_run) {
    ec2ko <- KEGGREST::keggLink("ec", "ko")
    ec2ko <- data.frame(
        ec = gsub("ec:", "", x = ec2ko, fixed = TRUE),
        ko = gsub("ko:", "", x = names(ec2ko), fixed = TRUE),
        row.names = NULL
    )

    ec2cpd <- KEGGREST::keggLink("ec", "cpd")
    ec2cpd <- data.frame(
        ec = gsub("ec:", "", x = ec2cpd, fixed = TRUE),
        cpd = gsub("cpd:", "", x = names(ec2cpd), fixed = TRUE),
        row.names = NULL
    )
}

}
\keyword{datasets}
